/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.nio.watch;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeWatcher
implements Runnable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final HashMap<WatchKey, Path> pathTable;
    protected final Path root;
    protected final boolean recursive;
    private WatchService watchService;

    public AbstractTreeWatcher(Path target, boolean recursive) {
        this.root = target;
        this.recursive = recursive;
        this.pathTable = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.debug("file-system watcher on {} ({}) starting up...", (Object)this.root, (Object)(this.recursive ? "recursive" : "non-recursive"));
        try {
            AbstractTreeWatcher abstractTreeWatcher = this;
            synchronized (abstractTreeWatcher) {
                if (this.watchService == null) {
                    this.watchService = FileSystems.getDefault().newWatchService();
                }
            }
            this.pathTable.clear();
            if (this.recursive) {
                this.registerAll(this.watchService, this.root);
            } else {
                this.register(this.watchService, this.root);
            }
            this.log.debug("watching...");
            try {
                block12: while (true) {
                    WatchKey key;
                    Path parent;
                    if ((parent = this.pathTable.get(key = this.watchService.take())) == null) {
                        this.log.warn("WatchKey not recognized: {}, ignoring event", (Object)key);
                        continue;
                    }
                    try {
                        Iterator<WatchEvent<?>> i$ = key.pollEvents().iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block12;
                            WatchEvent<?> event = i$.next();
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW) {
                                this.log.trace("overflow event for {}", (Object)parent);
                                continue;
                            }
                            WatchEvent<?> pathEvent = event;
                            Path localPath = (Path)pathEvent.context();
                            if (localPath == null) {
                                this.log.warn("Could not get context for %s in %s", kind, (Object)parent);
                                continue;
                            }
                            Path target = parent.resolve(localPath);
                            if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                                if (Files.isDirectory(target, new LinkOption[0])) {
                                    this.log.trace("created dir: {}", (Object)target);
                                    this.onDirectoryCreated(target);
                                    if (this.recursive) {
                                        this.registerAll(this.watchService, target);
                                    }
                                } else {
                                    this.log.trace("created file: {}", (Object)target);
                                    this.onFileCreated(target);
                                }
                                this.log.trace("new child in {}: {}", (Object)parent, (Object)localPath);
                                this.onChildCreated(parent, target);
                                continue;
                            }
                            if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                                this.log.trace("modified file: {}", (Object)target);
                                this.onFileModified(target);
                                continue;
                            }
                            if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                                this.log.trace("deleted child in {}: {}", (Object)parent, (Object)localPath);
                                this.onChildDeleted(parent, target);
                                continue;
                            }
                            this.log.error("Unexpected event type: {}", kind);
                        }
                    }
                    finally {
                        if (key.reset()) continue;
                        this.pathTable.remove(key);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                this.log.trace("shutting down...");
                this.watchService.close();
                this.watchService = null;
                this.log.info("file-system watcher on {} ({}) stopped.", (Object)this.root, (Object)(this.recursive ? "recursive" : "non-recursive"));
            }
        }
        catch (IOException e) {
            this.log.error("file-system watcher on {} ({}) died: {}", new Object[]{this.root, this.recursive ? "recursive" : "non-recursive", e.getMessage()});
        }
    }

    private void registerAll(final WatchService watcher, Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                AbstractTreeWatcher.this.register(watcher, dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private WatchKey register(WatchService watcher, Path dir) throws IOException {
        WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        Path prev = this.pathTable.get(key);
        if (prev == null) {
            this.log.trace("new watch on {}", (Object)dir);
        } else if (!dir.equals(prev)) {
            this.log.trace("updated watch on {} -> {}", (Object)prev, (Object)dir);
        }
        this.pathTable.put(key, dir);
        return key;
    }

    public void shutdown() throws IOException {
        if (this.watchService != null) {
            this.watchService.close();
        }
    }

    public abstract void onDirectoryCreated(Path var1);

    public abstract void onFileCreated(Path var1);

    public abstract void onFileModified(Path var1);

    public abstract void onChildCreated(Path var1, Path var2);

    public abstract void onChildDeleted(Path var1, Path var2);
}

