/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.model;

import info.aduna.iteration.CloseableIteration;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javolution.util.function.Predicate;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.TreeModel;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.Sail;
import org.openrdf.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelCommons {
    private static Logger log = LoggerFactory.getLogger(ModelCommons.class);

    public static RDFHandler createModelHandler(final Model model, final Predicate<Statement> ... filters) {
        return new RDFHandlerBase(){

            public void handleStatement(Statement st) throws RDFHandlerException {
                for (Predicate f : filters) {
                    if (f.test(st)) continue;
                    return;
                }
                model.add((Object)st);
            }
        };
    }

    public static void add(Model model, InputStream in, String baseURI, RDFFormat format, Predicate<Statement> ... filters) throws IOException, RDFParseException {
        try {
            RDFParser parser = Rio.createParser((RDFFormat)format);
            parser.setRDFHandler(ModelCommons.createModelHandler(model, filters));
            parser.parse(in, baseURI);
        }
        catch (RDFHandlerException e) {
            log.error("RepositoryException:", (Throwable)e);
        }
    }

    public static void add(Model model, Reader in, String baseURI, RDFFormat format, Predicate<Statement> ... filters) throws IOException, RDFParseException {
        try {
            RDFParser parser = Rio.createParser((RDFFormat)format);
            parser.setRDFHandler(ModelCommons.createModelHandler(model, filters));
            parser.parse(in, baseURI);
        }
        catch (RDFHandlerException e) {
            log.error("RepositoryException:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X extends Exception> void add(Model model, CloseableIteration<? extends Statement, X> triples, Predicate<Statement> ... filters) throws X {
        try {
            block3: while (triples.hasNext()) {
                Statement st = (Statement)triples.next();
                for (Predicate<Statement> f : filters) {
                    if (!f.test(st)) continue block3;
                }
                model.add((Object)st);
            }
        }
        finally {
            triples.close();
        }
    }

    public static void export(Model model, RDFHandler handler) throws RDFHandlerException {
        handler.startRDF();
        for (Statement stmt : model) {
            handler.handleStatement(stmt);
        }
        handler.endRDF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Repository asRepository(Model model) throws RepositoryException {
        SailRepository repository = new SailRepository((Sail)new MemoryStore());
        repository.initialize();
        try (RepositoryConnection con = repository.getConnection();){
            con.begin();
            con.add((Iterable)model, new Resource[0]);
            con.commit();
        }
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model asModel(Repository repository, Predicate<Statement> ... filters) throws RepositoryException {
        TreeModel model = new TreeModel();
        try (RepositoryConnection con = repository.getConnection();){
            con.begin();
            ModelCommons.add((Model)model, con.getStatements(null, null, null, true, new Resource[0]), filters);
            con.commit();
        }
        return model;
    }
}

