/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public class CountFunction<Node>
extends SelectorFunction<Node> {
    private final URI dataType = URI.create("http://www.w3.org/2001/XMLSchema#integer");

    @Override
    @SafeVarargs
    public final Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        LinkedList result = new LinkedList();
        for (Collection<Node> coll : args) {
            Object intLit = backend.createLiteral(String.valueOf(coll.size()), null, this.dataType);
            result.add(intLit);
        }
        return result;
    }

    @Override
    public String getSignature() {
        return "fn:count(nodes : URIResourceList, ...) : IntegerLiteralList";
    }

    @Override
    public String getDescription() {
        return "Counts the number of resources in the arguments";
    }

    @Override
    public String getLocalName() {
        return "count";
    }
}

