/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.programs;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.marmotta.ldpath.api.LDPathConstruct;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.tests.NodeTest;
import org.apache.marmotta.ldpath.model.fields.FieldMapping;

public class Program<Node>
implements LDPathConstruct<Node> {
    public static final Map<String, String> DEFAULT_NAMESPACES;
    public static final String DOCUMENT_BOOST_TYPE = "http://www.w3.org/2001/XMLSchema#float";
    private Map<String, String> namespaces = new LinkedHashMap<String, String>();
    private Set<URI> graphs;
    private NodeTest<Node> filter;
    private FieldMapping<Float, Node> booster;
    private Set<FieldMapping<?, Node>> fields = new LinkedHashSet();

    public Program() {
        this.graphs = new LinkedHashSet<URI>();
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public void addMapping(FieldMapping<?, Node> mapping) {
        this.fields.add(mapping);
    }

    public Set<FieldMapping<?, Node>> getFields() {
        return this.fields;
    }

    public FieldMapping<?, Node> getField(String name) {
        for (FieldMapping<?, Node> m : this.fields) {
            if (!name.equals(m.getFieldName())) continue;
            return m;
        }
        return null;
    }

    public void setFields(Set<FieldMapping<?, Node>> fields) {
        this.fields = fields;
    }

    public NodeTest<Node> getFilter() {
        return this.filter;
    }

    public void setFilter(NodeTest<Node> filter) {
        this.filter = filter;
    }

    public FieldMapping<Float, Node> getBooster() {
        return this.booster;
    }

    public void setBooster(FieldMapping<Float, Node> boost) {
        this.booster = boost;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = new LinkedHashMap<String, String>(namespaces);
    }

    public Set<URI> getGraphs() {
        return this.graphs;
    }

    public URI[] getGraphArr() {
        return this.graphs.toArray(new URI[0]);
    }

    public void setGraphs(Collection<URI> graphs) {
        this.graphs.clear();
        this.graphs.addAll(graphs);
    }

    public Map<String, Collection<?>> execute(RDFBackend<Node> backend, Node context) {
        HashMap result = new HashMap();
        for (FieldMapping<?, Node> mapping : this.getFields()) {
            result.put(mapping.getFieldName(), mapping.getValues(backend, context));
        }
        return result;
    }

    public Map<String, Collection<?>> execute(RDFBackend<Node> backend, Node context, Map<Node, List<Node>> paths) {
        HashMap result = new HashMap();
        for (FieldMapping<?, Node> mapping : this.getFields()) {
            result.put(mapping.getFieldName(), mapping.getValues(backend, context, paths));
        }
        return result;
    }

    @Override
    public String getPathExpression(NodeBackend<Node> backend) {
        StringBuilder sb = new StringBuilder();
        if (this.graphs != null && this.graphs.size() > 0) {
            sb.append("@graph");
            boolean first = true;
            for (URI graph : this.graphs) {
                if (first) {
                    sb.append(" <");
                } else {
                    sb.append(", <");
                }
                sb.append(graph.toString()).append(">");
                first = false;
            }
            sb.append(" ;\n");
        }
        if (this.filter != null) {
            sb.append(String.format("@filter %s ;%n", this.filter.getPathExpression(backend)));
        }
        if (this.booster != null) {
            sb.append(String.format("@boost %s ;%n", this.booster.getSelector().getPathExpression(backend)));
        }
        for (FieldMapping<?, Node> field : this.fields) {
            sb.append(String.format("  %s%n", field.getPathExpression(backend)));
        }
        String progWithoutNamespace = sb.toString();
        TreeSet<Map.Entry<String, String>> sortedNamespaces = new TreeSet<Map.Entry<String, String>>(new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                return e2.getValue().compareTo(e1.getValue());
            }
        });
        sortedNamespaces.addAll(this.namespaces.entrySet());
        for (Map.Entry<String, String> ns : sortedNamespaces) {
            progWithoutNamespace = progWithoutNamespace.replaceAll("<" + Pattern.quote(ns.getValue()) + "([^>]*)>", Matcher.quoteReplacement(ns.getKey()) + ":$1");
        }
        for (Map.Entry<String, String> ns : DEFAULT_NAMESPACES.entrySet()) {
            if (this.namespaces.containsKey(ns.getKey())) continue;
            progWithoutNamespace = progWithoutNamespace.replaceAll("<" + Pattern.quote(ns.getValue()) + "([^>]*)>", Matcher.quoteReplacement(ns.getKey()) + ":$1");
        }
        StringBuilder prefixes = new StringBuilder();
        for (Map.Entry<String, String> ns : this.namespaces.entrySet()) {
            prefixes.append(String.format("@prefix %s: <%s> ;%n", ns.getKey(), ns.getValue()));
        }
        return prefixes.append(progWithoutNamespace).toString();
    }

    static {
        HashMap<String, String> defNS = new HashMap<String, String>();
        defNS.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        defNS.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        defNS.put("owl", "http://www.w3.org/2002/07/owl#");
        defNS.put("skos", "http://www.w3.org/2004/02/skos/core#");
        defNS.put("foaf", "http://xmlns.com/foaf/0.1/");
        defNS.put("dc", "http://purl.org/dc/elements/1.1/");
        defNS.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        defNS.put("lmf", "http://www.newmedialab.at/lmf/types/1.0/");
        defNS.put("fn", "http://www.newmedialab.at/lmf/functions/1.0/");
        DEFAULT_NAMESPACES = Collections.unmodifiableMap(defNS);
    }
}

