/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.tests;

import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.tests.NodeTest;
import org.apache.marmotta.ldpath.model.tests.ComplexTest;

public class OrTest<Node>
extends ComplexTest<Node> {
    private NodeTest<Node> left;
    private NodeTest<Node> right;

    public OrTest(NodeTest<Node> left, NodeTest<Node> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node args) throws IllegalArgumentException {
        return this.left.accept(rdfBackend, context, args) || this.right.accept(rdfBackend, context, args);
    }

    @Override
    public String getPathExpression(NodeBackend<Node> rdfBackend) {
        return String.format("%s | %s", this.left.getPathExpression(rdfBackend), this.right.getPathExpression(rdfBackend));
    }

    @Override
    public String getSignature() {
        return "(left  | right ) :: (Boolean, Boolean) -> Boolean";
    }

    @Override
    public String getDescription() {
        return "Tests the disjunction of two tests";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrTest orTest = (OrTest)o;
        if (this.left != null ? !this.left.equals(orTest.left) : orTest.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(orTest.right) : orTest.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }
}

