/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import javolution.lang.Immutable;
import javolution.lang.Parallelizable;
import javolution.lang.Realtime;
import javolution.util.function.Consumer;
import javolution.util.function.Equality;
import javolution.util.function.Function;
import javolution.util.function.Predicate;
import javolution.util.function.Reducer;
import javolution.util.function.Reducers;
import javolution.util.internal.collection.AtomicCollectionImpl;
import javolution.util.internal.collection.DistinctCollectionImpl;
import javolution.util.internal.collection.FilteredCollectionImpl;
import javolution.util.internal.collection.MappedCollectionImpl;
import javolution.util.internal.collection.ReversedCollectionImpl;
import javolution.util.internal.collection.SequentialCollectionImpl;
import javolution.util.internal.collection.SharedCollectionImpl;
import javolution.util.internal.collection.SortedCollectionImpl;
import javolution.util.internal.collection.UnmodifiableCollectionImpl;
import javolution.util.service.CollectionService;

@Realtime
public abstract class FastCollection<E>
implements Collection<E>,
Serializable {
    private static final long serialVersionUID = 1536L;

    protected FastCollection() {
    }

    @Parallelizable(mutexFree=true, comment="Except for write operations, all read operations are mutex-free.")
    public FastCollection<E> atomic() {
        return new AtomicCollectionImpl<E>(this.service());
    }

    @Parallelizable(mutexFree=false, comment="Use multiple-readers/single-writer lock.")
    public FastCollection<E> shared() {
        return new SharedCollectionImpl<E>(this.service());
    }

    public FastCollection<E> sequential() {
        return new SequentialCollectionImpl<E>(this.service());
    }

    public FastCollection<E> unmodifiable() {
        return new UnmodifiableCollectionImpl<E>(this.service());
    }

    public FastCollection<E> filtered(Predicate<? super E> filter) {
        return new FilteredCollectionImpl<E>(this.service(), filter);
    }

    public <R> FastCollection<R> mapped(Function<? super E, ? extends R> function) {
        return new MappedCollectionImpl<E, R>(this.service(), function);
    }

    public FastCollection<E> sorted() {
        return new SortedCollectionImpl<E>(this.service(), this.comparator());
    }

    public FastCollection<E> sorted(Comparator<? super E> cmp) {
        return new SortedCollectionImpl<E>(this.service(), cmp);
    }

    public FastCollection<E> reversed() {
        return new ReversedCollectionImpl<E>(this.service());
    }

    public FastCollection<E> distinct() {
        return new DistinctCollectionImpl<E>(this.service());
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public void perform(Consumer<? extends Collection<E>> action) {
        this.service().perform(action, this.service());
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public void update(Consumer<? extends Collection<E>> action) {
        this.service().update(action, this.service());
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public void forEach(final Consumer<? super E> consumer) {
        this.perform(new Consumer<Collection<E>>(){

            @Override
            public void accept(Collection<E> view) {
                Iterator it = view.iterator();
                while (it.hasNext()) {
                    consumer.accept(it.next());
                }
            }
        });
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public boolean removeIf(final Predicate<? super E> filter) {
        final boolean[] removed = new boolean[1];
        this.update(new Consumer<Collection<E>>(){

            @Override
            public void accept(Collection<E> view) {
                Iterator it = view.iterator();
                while (it.hasNext()) {
                    if (!filter.test(it.next())) continue;
                    it.remove();
                    removed[0] = true;
                }
            }
        });
        return removed[0];
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public E reduce(Reducer<E> reducer) {
        this.perform(reducer);
        return (E)reducer.get();
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR, comment="Could iterate the whole collection (e.g. distinct view).")
    public boolean add(E element) {
        return this.service().add(element);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR, comment="Could iterate the whole collection (e.g. filtered view).")
    public boolean isEmpty() {
        return this.iterator().hasNext();
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR, comment="Could count the elements (e.g. filtered view).")
    public int size() {
        return this.service().size();
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR, comment="Could remove the elements one at a time.")
    public void clear() {
        this.service().clear();
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR, comment="Could search the whole collection.")
    public boolean contains(Object searched) {
        return this.service().contains(searched);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR, comment="Could search the whole collection.")
    public boolean remove(Object searched) {
        return this.service().remove(searched);
    }

    @Override
    @Realtime(limit=Realtime.Limit.N_SQUARE, comment="Sorted view iterator require sorting the elements.")
    public Iterator<E> iterator() {
        return this.service().iterator();
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public boolean addAll(Collection<? extends E> that) {
        return this.service().addAll(that);
    }

    @Override
    @Realtime(limit=Realtime.Limit.N_SQUARE)
    public boolean containsAll(Collection<?> that) {
        return this.service().containsAll(that);
    }

    @Override
    @Realtime(limit=Realtime.Limit.N_SQUARE)
    public boolean removeAll(Collection<?> that) {
        return this.service().removeAll(that);
    }

    @Override
    @Realtime(limit=Realtime.Limit.N_SQUARE)
    public boolean retainAll(Collection<?> that) {
        return this.service().retainAll(that);
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public Object[] toArray() {
        return this.service().toArray();
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public <T> T[] toArray(T[] array) {
        return this.service().toArray(array);
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public <T extends E> T any(Class<T> type) {
        return this.reduce(Reducers.any(type));
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public E min() {
        return this.reduce(Reducers.min(this.comparator()));
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public E max() {
        return this.reduce(Reducers.max(this.comparator()));
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public FastCollection<E> addAll(E ... elements) {
        for (E e : elements) {
            this.add(e);
        }
        return this;
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public FastCollection<E> addAll(FastCollection<? extends E> that) {
        this.addAll((Collection<? extends E>)that);
        return this;
    }

    @Realtime(limit=Realtime.Limit.CONSTANT)
    public Equality<? super E> comparator() {
        return this.service().comparator();
    }

    @Realtime(limit=Realtime.Limit.CONSTANT)
    public <T extends Collection<E>> Immutable<T> toImmutable() {
        return new Immutable<T>(){
            final T value;
            {
                this.value = FastCollection.this.unmodifiable();
            }

            @Override
            public T value() {
                return this.value;
            }
        };
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public boolean equals(Object obj) {
        if (obj instanceof FastCollection) {
            return this.service().equals(((FastCollection)obj).service());
        }
        return false;
    }

    @Override
    @Realtime(limit=Realtime.Limit.LINEAR)
    public int hashCode() {
        return this.service().hashCode();
    }

    @Realtime(limit=Realtime.Limit.LINEAR)
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            builder.append(it.next().toString());
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    protected abstract CollectionService<E> service();

    protected static <E> CollectionService<E> serviceOf(FastCollection<E> collection) {
        return collection.service();
    }
}

