/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map.sorted;

import java.util.Iterator;
import java.util.Map;
import javolution.util.function.Equality;
import javolution.util.internal.map.MapView;
import javolution.util.internal.map.sorted.MapEntryImpl;
import javolution.util.internal.map.sorted.SortedMapView;
import javolution.util.internal.table.sorted.FastSortedTableImpl;

public class FastSortedMapImpl<K, V>
extends SortedMapView<K, V> {
    private static final long serialVersionUID = 1536L;
    private FastSortedTableImpl<Map.Entry<K, V>> entries = new FastSortedTableImpl(new MapView.EntryComparator());
    private final Equality<? super K> keyComparator;
    private final Equality<? super V> valueComparator;

    public FastSortedMapImpl(Equality<? super K> keyComparator, Equality<? super V> valueComparator) {
        super(null);
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entries.contains(new MapEntryImpl<Object, Object>(key, null));
    }

    @Override
    public K firstKey() {
        return ((Map.Entry)this.entries.getFirst()).getKey();
    }

    @Override
    public V get(Object key) {
        int i = this.entries.indexOf(new MapEntryImpl<Object, Object>(key, null));
        return i >= 0 ? (V)((Map.Entry)this.entries.get(i)).getValue() : null;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.entries.iterator();
    }

    @Override
    public Equality<? super K> keyComparator() {
        return this.keyComparator;
    }

    @Override
    public K lastKey() {
        return ((Map.Entry)this.entries.getLast()).getKey();
    }

    @Override
    public V put(K key, V value) {
        MapEntryImpl<K, V> entry = new MapEntryImpl<K, V>(key, value);
        int i = this.entries.positionOf(entry);
        if (i < this.size()) {
            Map.Entry e = (Map.Entry)this.entries.get(i);
            if (this.keyComparator().areEqual(key, e.getKey())) {
                Object previous = e.getValue();
                e.setValue(value);
                return previous;
            }
        }
        this.entries.add(i, entry);
        return null;
    }

    @Override
    public V remove(Object key) {
        int i = this.entries.indexOf(new MapEntryImpl<Object, Object>(key, null));
        if (i < 0) {
            return null;
        }
        Map.Entry e = (Map.Entry)this.entries.get(i);
        Object previous = e.getValue();
        this.entries.remove(i);
        return previous;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Equality<? super V> valueComparator() {
        return this.valueComparator;
    }
}

