/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.repository;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.apache.marmotta.commons.sesame.repository.ExceptionUtils;
import org.apache.marmotta.commons.sesame.repository.ResourceConnection;
import org.apache.marmotta.commons.sesame.repository.ResultUtils;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.helpers.SailConnectionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    @Deprecated
    public static boolean existsResource(RepositoryConnection conn, String uri) {
        return ResourceUtils.isUsed(conn, (Resource)conn.getValueFactory().createURI(uri));
    }

    public static boolean isSubject(RepositoryConnection conn, String uri) {
        return ResourceUtils.isSubject(conn, (Resource)conn.getValueFactory().createURI(uri));
    }

    public static boolean isSubject(RepositoryConnection conn, Resource rsc) {
        return ResourceUtils.existsStatement(conn, rsc, null, null, new Resource[0]);
    }

    public static boolean isPredicate(RepositoryConnection conn, String uri) {
        return ResourceUtils.isPredicate(conn, conn.getValueFactory().createURI(uri));
    }

    public static boolean isPredicate(RepositoryConnection conn, URI uri) {
        return ResourceUtils.existsStatement(conn, null, uri, null, new Resource[0]);
    }

    public static boolean isObject(RepositoryConnection conn, String uri) {
        return ResourceUtils.isObject(conn, (Value)conn.getValueFactory().createURI(uri));
    }

    public static boolean isObject(RepositoryConnection conn, Value val) {
        return ResourceUtils.existsStatement(conn, null, null, val, new Resource[0]);
    }

    public static boolean isContext(RepositoryConnection conn, String uri) {
        return ResourceUtils.isContext(conn, (Resource)conn.getValueFactory().createURI(uri));
    }

    public static boolean isContext(RepositoryConnection conn, Resource rsc) {
        return ResourceUtils.existsStatement(conn, null, null, null, rsc);
    }

    public static boolean isUsed(RepositoryConnection conn, Resource rsc) {
        if (ResourceUtils.isSubject(conn, rsc) || ResourceUtils.isContext(conn, rsc) || ResourceUtils.isObject(conn, (Value)rsc)) {
            return true;
        }
        return rsc instanceof URI && ResourceUtils.isPredicate(conn, (URI)rsc);
    }

    public static boolean existsStatement(RepositoryConnection conn, Resource subj, URI pred, Value object, Resource ... context) {
        try {
            return conn.hasStatement(subj, pred, object, true, context);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @Deprecated
    public static URI getUriResource(RepositoryConnection con, String uri) {
        URI rsc = con.getValueFactory().createURI(uri);
        if (ResourceUtils.isUsed(con, (Resource)rsc)) {
            return rsc;
        }
        return null;
    }

    public static BNode getAnonResource(RepositoryConnection con, String id) {
        BNode bNode = con.getValueFactory().createBNode(id);
        if (ResourceUtils.isUsed(con, (Resource)bNode)) {
            return bNode;
        }
        return null;
    }

    public static void removeResource(RepositoryConnection con, Resource resource) throws RepositoryException {
        con.remove(resource, null, null, new Resource[0]);
        if (resource instanceof URI) {
            con.remove((Resource)null, (URI)resource, null, new Resource[0]);
        }
        con.remove((Resource)null, null, (Value)resource, new Resource[0]);
        con.remove((Resource)null, null, null, new Resource[]{resource});
    }

    public static Iterable<Resource> listResources(RepositoryConnection con) {
        final ResourceConnection rcon = ResourceUtils.getWrappedResourceConnection(con);
        if (rcon != null) {
            return new Iterable<Resource>(){

                @Override
                public Iterator<Resource> iterator() {
                    try {
                        return ResultUtils.unwrap(rcon.getResources());
                    }
                    catch (RepositoryException e) {
                        ExceptionUtils.handleRepositoryException(e, ResourceUtils.class);
                        return Iterators.emptyIterator();
                    }
                }
            };
        }
        return ResourceUtils.listSubjectsInternal(con, null, null, null);
    }

    public static Iterable<Resource> listSubjects(RepositoryConnection con) {
        return ResourceUtils.listSubjectsInternal(con, null, null, null);
    }

    public static Iterable<Resource> listResources(RepositoryConnection con, Resource type) {
        return ResourceUtils.listResources(con, type, null);
    }

    public static Iterable<Resource> listResources(RepositoryConnection con, Resource type, URI context) {
        URI rdf_type = con.getValueFactory().createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        return ResourceUtils.listSubjectsInternal(con, rdf_type, (Value)type, context);
    }

    public static Iterable<URI> listResourcesByPrefix(final RepositoryConnection con, final String prefix, final int offset, final int limit) {
        final ResourceConnection rcon = ResourceUtils.getWrappedResourceConnection(con);
        if (rcon != null) {
            return new Iterable<URI>(){

                @Override
                public Iterator<URI> iterator() {
                    try {
                        Iterator<URI> result = ResultUtils.unwrap(rcon.getResources(prefix));
                        Iterators.advance(result, (int)offset);
                        if (limit > 0) {
                            return Iterators.limit(result, (int)limit);
                        }
                        return result;
                    }
                    catch (RepositoryException e) {
                        ExceptionUtils.handleRepositoryException(e, ResourceUtils.class);
                        return Iterators.emptyIterator();
                    }
                }
            };
        }
        return new Iterable<URI>(){

            @Override
            public Iterator<URI> iterator() {
                Iterator result = Iterators.transform((Iterator)Iterators.filter(ResourceUtils.listResources(con).iterator(), (Predicate)new Predicate<Resource>(){

                    public boolean apply(Resource input) {
                        return input instanceof URI && input.stringValue().startsWith(prefix);
                    }
                }), (Function)new Function<Resource, URI>(){

                    public URI apply(Resource input) {
                        return (URI)input;
                    }
                });
                Iterators.advance((Iterator)result, (int)offset);
                if (limit > 0) {
                    return Iterators.limit((Iterator)result, (int)limit);
                }
                return result;
            }
        };
    }

    public static Iterable<URI> listResourcesByPrefix(RepositoryConnection con, String prefix) {
        return ResourceUtils.listResourcesByPrefix(con, prefix, 0, 0);
    }

    private static Iterable<Resource> listSubjectsInternal(final RepositoryConnection con, final URI property, final Value value, URI context) {
        final Resource[] contexts = context != null ? new Resource[]{context} : new Resource[]{};
        return new Iterable<Resource>(){

            @Override
            public Iterator<Resource> iterator() {
                try {
                    return Iterators.filter((Iterator)Iterators.transform(ResultUtils.unwrap(con.getStatements(null, property, value, true, contexts)), (Function)new Function<Statement, Resource>(){

                        public Resource apply(Statement input) {
                            return input.getSubject();
                        }
                    }), (Predicate)new Predicate<Resource>(){
                        private HashSet<Integer> visited = new HashSet();

                        public boolean apply(Resource input) {
                            if (!this.visited.contains(input.hashCode())) {
                                this.visited.add(input.hashCode());
                                return true;
                            }
                            return false;
                        }
                    });
                }
                catch (RepositoryException e) {
                    ExceptionUtils.handleRepositoryException(e, ResourceUtils.class);
                    return Iterators.emptyIterator();
                }
            }
        };
    }

    public static String getProperty(RepositoryConnection con, Resource r, String propLabel) throws RepositoryException {
        return ResourceUtils.getProperty(con, r, propLabel, null, null);
    }

    public static String getProperty(RepositoryConnection con, Resource r, String propLabel, URI context) throws RepositoryException {
        return ResourceUtils.getProperty(con, r, propLabel, null, context);
    }

    public static String getProperty(RepositoryConnection con, Resource r, String propLabel, Locale loc) throws RepositoryException {
        return ResourceUtils.getProperty(con, r, propLabel, loc, null);
    }

    public static String getProperty(RepositoryConnection con, Resource r, String propLabel, Locale loc, URI context) throws RepositoryException {
        Literal l = ResourceUtils.getLiteral(con, r, propLabel, loc, context);
        if (l == null) {
            return null;
        }
        return l.stringValue();
    }

    private static Literal getLiteral(RepositoryConnection con, Resource r, String propLabel, Locale loc, URI context) throws RepositoryException {
        for (Value value : ResourceUtils.listOutgoingNodes(con, r, propLabel, context)) {
            if (!(value instanceof Literal)) continue;
            if (loc == null && ((Literal)value).getLanguage() == null) {
                return (Literal)value;
            }
            if (loc == null || ((Literal)value).getLanguage() == null || !((Literal)value).getLanguage().equals(loc.getLanguage().toLowerCase())) continue;
            return (Literal)value;
        }
        return null;
    }

    public static Iterable<String> getProperties(RepositoryConnection con, Resource r, String propLabel) throws RepositoryException {
        return ResourceUtils.getProperties(con, r, propLabel, null, null);
    }

    public static Iterable<String> getProperties(RepositoryConnection con, Resource r, String propLabel, Locale loc, URI context) throws RepositoryException {
        return Iterables.transform(ResourceUtils.listLiterals(con, r, propLabel, loc, context), (Function)new Function<Literal, String>(){

            public String apply(Literal input) {
                return input.getLabel();
            }
        });
    }

    private static Iterable<Literal> listLiterals(RepositoryConnection con, Resource r, String propLabel, final Locale loc, URI context) throws RepositoryException {
        return Iterables.filter((Iterable)Iterables.filter(ResourceUtils.listOutgoingNodes(con, r, propLabel, context), Literal.class), (Predicate)new Predicate<Literal>(){

            public boolean apply(Literal input) {
                return input.getLanguage() == null && loc == null || input.getLanguage() != null && input.getLanguage().equals(loc.getLanguage().toLowerCase());
            }
        });
    }

    public static void setProperty(RepositoryConnection con, Resource r, String propLabel, String propValue) throws RepositoryException {
        ResourceUtils.setProperty(con, r, propLabel, propValue, (URI)null);
    }

    public static <T> void setProperty(RepositoryConnection con, Resource r, String propLabel, String propValue, URI context) throws RepositoryException {
        ResourceUtils.setProperty(con, r, propLabel, propValue, null, context);
    }

    public static <T> void setProperty(RepositoryConnection con, Resource r, String propLabel, String propValue, Locale loc) throws RepositoryException {
        ResourceUtils.setProperty(con, r, propLabel, propValue, null, null);
    }

    public static <T> void setProperty(RepositoryConnection con, Resource r, String propLabel, String propValue, Locale loc, URI context) throws RepositoryException {
        if (propValue != null) {
            Resource[] contexts = context != null ? new Resource[]{context} : new Resource[]{};
            ResourceUtils.removeProperty(con, r, propLabel, loc, context);
            String prop_uri = ResourceUtils.resolvePropLabel(con, propLabel);
            Literal value = con.getValueFactory().createLiteral(propValue, loc != null ? loc.getLanguage().toLowerCase() : null);
            URI prop = con.getValueFactory().createURI(prop_uri);
            con.add(r, prop, (Value)value, contexts);
        } else {
            ResourceUtils.removeProperty(con, r, propLabel, loc, context);
        }
    }

    public static boolean removeProperty(RepositoryConnection con, Resource r, String propLabel) throws RepositoryException {
        return ResourceUtils.removeProperty(con, r, propLabel, (Locale)null);
    }

    public static boolean removeProperty(RepositoryConnection con, Resource r, String propLabel, URI context) throws RepositoryException {
        return ResourceUtils.removeProperty(con, r, propLabel, null, context);
    }

    public static boolean removeProperty(RepositoryConnection con, Resource r, String propLabel, Locale loc) throws RepositoryException {
        return ResourceUtils.removeProperty(con, r, propLabel, loc, null);
    }

    public static boolean removeProperty(RepositoryConnection con, Resource r, String propLabel, Locale loc, URI context) throws RepositoryException {
        String uri = ResourceUtils.resolvePropLabel(con, propLabel);
        URI property = con.getValueFactory().createURI(uri);
        if (property != null) {
            ArrayList<Statement> remove = new ArrayList<Statement>();
            RepositoryResult triples = con.getStatements(r, property, null, false, new Resource[]{context});
            while (triples.hasNext()) {
                Statement t = (Statement)triples.next();
                if (!(t.getObject() instanceof Literal) || loc != null && !((Literal)t.getObject()).getLanguage().equals(loc.getLanguage().toLowerCase())) continue;
                remove.add(t);
            }
            if (remove.size() > 0) {
                for (Statement triple : remove) {
                    con.remove(triple, new Resource[0]);
                }
                return true;
            }
        }
        return false;
    }

    public static Iterable<? extends Statement> listOutgoing(RepositoryConnection con, Resource r) throws RepositoryException {
        return ResourceUtils.listOutgoing(con, r, (URI)null);
    }

    public static Iterable<? extends Statement> listOutgoing(RepositoryConnection con, Resource r, URI context) throws RepositoryException {
        return ResourceUtils.listOutgoing(con, r, null, context);
    }

    public static Iterable<? extends Statement> listOutgoing(RepositoryConnection con, Resource r, String propLabel) throws RepositoryException {
        return ResourceUtils.listOutgoing(con, r, propLabel, null);
    }

    public static Iterable<? extends Statement> listOutgoing(final RepositoryConnection con, final Resource r, String propLabel, URI context) throws RepositoryException {
        URI property;
        if (propLabel != null) {
            String prop_uri = ResourceUtils.resolvePropLabel(con, propLabel);
            if (prop_uri == null) {
                return Collections.emptySet();
            }
            property = con.getValueFactory().createURI(prop_uri);
        } else {
            property = null;
        }
        final Resource[] contexts = context != null ? new Resource[]{context} : new Resource[]{};
        return new Iterable<Statement>(){

            @Override
            public Iterator<Statement> iterator() {
                try {
                    return ResultUtils.unwrap(con.getStatements(r, property, null, true, contexts));
                }
                catch (RepositoryException ex) {
                    ExceptionUtils.handleRepositoryException(ex, ResourceUtils.class);
                    return Iterators.emptyIterator();
                }
            }
        };
    }

    public static Iterable<? extends Value> listOutgoingNodes(RepositoryConnection con, Resource r, String propLabel) throws RepositoryException {
        return ResourceUtils.listOutgoingNodes(con, r, propLabel, null);
    }

    public static Iterable<? extends Value> listOutgoingNodes(RepositoryConnection con, Resource r, String propLabel, URI context) throws RepositoryException {
        return Iterables.transform(ResourceUtils.listOutgoing(con, r, propLabel, context), (Function)new Function<Statement, Value>(){

            public Value apply(Statement input) {
                return input.getObject();
            }
        });
    }

    public static void addOutgoingNode(RepositoryConnection con, Resource r, String propLabel, Value target, URI context) throws RepositoryException {
        Resource[] contexts = context != null ? new Resource[]{context} : new Resource[]{};
        String property_uri = ResourceUtils.resolvePropLabel(con, propLabel);
        URI prop = con.getValueFactory().createURI(property_uri);
        con.add(r, prop, target, contexts);
    }

    @Deprecated
    public static void addOutgoingNode(RepositoryConnection con, Resource r, URI prop, Value target, URI context) throws RepositoryException {
        Resource[] contexts = context != null ? new Resource[]{context} : new Resource[]{};
        con.add(r, prop, target, contexts);
    }

    public static void removeOutgoingNode(RepositoryConnection con, Resource r, String propLabel, Resource target, URI context) throws RepositoryException {
        Resource[] contexts = context != null ? new Resource[]{context} : new Resource[]{};
        String property_uri = ResourceUtils.resolvePropLabel(con, propLabel);
        URI prop = con.getValueFactory().createURI(property_uri);
        con.remove(r, prop, (Value)target, contexts);
    }

    public static Iterable<? extends Statement> listIncoming(RepositoryConnection con, Resource r) throws RepositoryException {
        return ResourceUtils.listIncoming(con, r, (URI)null);
    }

    public static Iterable<? extends Statement> listIncoming(RepositoryConnection con, Resource r, URI context) throws RepositoryException {
        return ResourceUtils.listIncoming(con, r, null, context);
    }

    public static Iterable<? extends Statement> listIncoming(RepositoryConnection con, Resource r, String propLabel) throws RepositoryException {
        return ResourceUtils.listIncoming(con, r, propLabel, null);
    }

    public static Iterable<? extends Statement> listIncoming(final RepositoryConnection con, final Resource r, String propLabel, URI context) throws RepositoryException {
        URI property;
        if (propLabel != null) {
            String prop_uri = ResourceUtils.resolvePropLabel(con, propLabel);
            if (prop_uri == null) {
                return Collections.emptySet();
            }
            property = con.getValueFactory().createURI(prop_uri);
        } else {
            property = null;
        }
        final Resource[] contexts = context != null ? new Resource[]{context} : new Resource[]{};
        return new Iterable<Statement>(){

            @Override
            public Iterator<Statement> iterator() {
                try {
                    return ResultUtils.unwrap(con.getStatements(null, property, (Value)r, true, contexts));
                }
                catch (RepositoryException ex) {
                    ExceptionUtils.handleRepositoryException(ex, ResourceUtils.class);
                    return Iterators.emptyIterator();
                }
            }
        };
    }

    public static Iterable<? extends Resource> listIncomingNodes(RepositoryConnection con, Resource r, String propLabel) throws RepositoryException {
        return ResourceUtils.listIncomingNodes(con, r, propLabel, null);
    }

    public static Iterable<? extends Resource> listIncomingNodes(RepositoryConnection con, Resource r, String propLabel, URI context) throws RepositoryException {
        return Iterables.transform(ResourceUtils.listIncoming(con, r, propLabel, context), (Function)new Function<Statement, Resource>(){

            public Resource apply(Statement input) {
                return input.getSubject();
            }
        });
    }

    public static String getLabel(RepositoryConnection con, Resource r) throws RepositoryException {
        return ResourceUtils.getLabel(con, r, (Locale)null);
    }

    public static String getLabel(RepositoryConnection con, Resource r, URI context) throws RepositoryException {
        return ResourceUtils.getLabel(con, r, null, context);
    }

    public static String getLabel(RepositoryConnection con, Resource r, Locale loc) throws RepositoryException {
        return ResourceUtils.getLabel(con, r, loc, null);
    }

    public static String getLabel(RepositoryConnection con, Resource r, Locale loc, URI context) throws RepositoryException {
        String property;
        String label = null;
        String[] properties = new String[]{"http://www.w3.org/2000/01/rdf-schema#label", "http://purl.org/dc/terms/title", "http://purl.org/dc/elements/1.1/title", "http://www.w3.org/2004/02/skos/core#prefLabel"};
        Object[] arr$ = properties;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (label = ResourceUtils.getProperty(con, r, property = arr$[i$], loc, context)) == null; ++i$) {
        }
        if (label == null && loc == null) {
            block1: for (Locale loc2 : new Locale[]{Locale.ENGLISH, Locale.GERMAN}) {
                for (String property2 : properties) {
                    label = ResourceUtils.getProperty(con, r, property2, loc2, context);
                    if (label != null) break block1;
                }
            }
        }
        if (label == null && r instanceof URI) {
            String uri = r.stringValue();
            label = uri.lastIndexOf("#") > 0 ? uri.substring(uri.lastIndexOf("#") + 1) : uri.substring(uri.lastIndexOf("/") + 1);
        } else if (label == null && r instanceof BNode) {
            label = r.stringValue();
        }
        return label;
    }

    public static void setLabel(RepositoryConnection con, Resource r, String label) throws RepositoryException {
        ResourceUtils.setLabel(con, r, null, label, null);
    }

    public static void setLabel(RepositoryConnection con, Resource r, String label, URI context) throws RepositoryException {
        ResourceUtils.setLabel(con, r, null, label, context);
    }

    public static void setLabel(RepositoryConnection con, Resource r, Locale loc, String label) throws RepositoryException {
        ResourceUtils.setLabel(con, r, loc, label, null);
    }

    public static void setLabel(RepositoryConnection con, Resource r, Locale loc, String label, URI context) throws RepositoryException {
        ResourceUtils.setProperty(con, r, "<http://www.w3.org/2000/01/rdf-schema#label>", label, loc, context);
    }

    public static Iterable<? extends Resource> getTypes(RepositoryConnection con, Resource r) throws RepositoryException {
        return ResourceUtils.getTypes(con, r, null);
    }

    public static Iterable<? extends Resource> getTypes(final RepositoryConnection con, final Resource r, Resource context) throws RepositoryException {
        final URI rdf_type = con.getValueFactory().createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        if (rdf_type != null) {
            final Resource[] contexts = context != null ? new Resource[]{context} : new Resource[]{};
            return Iterables.transform((Iterable)Iterables.filter((Iterable)new Iterable<Statement>(){

                @Override
                public Iterator<Statement> iterator() {
                    try {
                        return ResultUtils.unwrap(con.getStatements(r, rdf_type, null, true, contexts));
                    }
                    catch (RepositoryException e) {
                        ExceptionUtils.handleRepositoryException(e, ResourceUtils.class);
                        return Iterators.emptyIterator();
                    }
                }
            }, (Predicate)new Predicate<Statement>(){

                public boolean apply(Statement input) {
                    return input.getObject() instanceof Resource;
                }
            }), (Function)new Function<Statement, Resource>(){

                public Resource apply(Statement input) {
                    return (Resource)input.getObject();
                }
            });
        }
        return Collections.emptyList();
    }

    public static boolean hasType(RepositoryConnection con, Resource r, String typeUri) throws RepositoryException {
        return ResourceUtils.hasType(con, r, con.getValueFactory().createURI(typeUri));
    }

    public static boolean hasType(RepositoryConnection con, Resource r, URI type) throws RepositoryException {
        return ResourceUtils.hasType(con, r, type, null);
    }

    public static boolean hasType(RepositoryConnection con, Resource r, URI type, URI context) throws RepositoryException {
        URI rdf_type;
        if (type != null && (rdf_type = con.getValueFactory().createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) != null) {
            if (context != null) {
                return con.hasStatement(r, rdf_type, (Value)type, true, new Resource[]{context});
            }
            return con.hasStatement(r, rdf_type, (Value)type, true, new Resource[0]);
        }
        return false;
    }

    public static void addType(RepositoryConnection con, Resource r, URI type, URI ... context) throws RepositoryException {
        URI rdf_type;
        if (type != null && (rdf_type = con.getValueFactory().createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) != null) {
            con.add(r, rdf_type, (Value)type, (Resource[])context);
        }
    }

    private static String resolvePropLabel(RepositoryConnection con, String propLabel) throws RepositoryException {
        String uri = propLabel;
        if (uri.startsWith("<") && uri.endsWith(">")) {
            uri = uri.substring(1, uri.length() - 1);
        } else if (!uri.contains("://") && uri.contains(":")) {
            String[] components = uri.split(":");
            if (components.length == 2) {
                String ns_prefix = components[0];
                String ns_local = components[1];
                String ns = con.getNamespace(ns_prefix);
                if (ns == null) {
                    log.error("could not find namespace with the given prefix");
                } else {
                    uri = ns + ns_local;
                }
            } else {
                log.error("could not properly split property identifier #0, as it contained more than one ':'", (Object)uri);
            }
        }
        return uri;
    }

    public static boolean isResource(Value v) {
        return v instanceof Resource;
    }

    public static boolean isURI(Value v) {
        return v instanceof URI;
    }

    public static boolean isBNode(Value v) {
        return v instanceof BNode;
    }

    public static boolean isLiteral(Value v) {
        return v instanceof Literal;
    }

    private static ResourceConnection getWrappedResourceConnection(SailConnection connection) {
        if (connection instanceof ResourceConnection) {
            return (ResourceConnection)connection;
        }
        if (connection instanceof SailConnectionWrapper) {
            return ResourceUtils.getWrappedResourceConnection(((SailConnectionWrapper)connection).getWrappedConnection());
        }
        return null;
    }

    private static ResourceConnection getWrappedResourceConnection(RepositoryConnection connection) {
        if (connection instanceof SailRepositoryConnection) {
            return ResourceUtils.getWrappedResourceConnection(((SailRepositoryConnection)connection).getSailConnection());
        }
        return null;
    }

    public static Date getCreated(RepositoryConnection conn, Resource resource) {
        try {
            Method m = resource.getClass().getMethod("getCreated", new Class[0]);
            return (Date)m.invoke((Object)resource, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getLastModified(RepositoryConnection conn, Resource resource) throws RepositoryException {
        Date last_modified;
        block7: {
            last_modified = new Date(0L);
            RepositoryResult triples = conn.getStatements(resource, null, null, false, new Resource[0]);
            block5: while (true) {
                while (triples.hasNext()) {
                    Statement triple = (Statement)triples.next();
                    try {
                        Method m = triple.getClass().getMethod("getCreated", new Class[0]);
                        Date created = (Date)m.invoke((Object)triple, new Object[0]);
                        if (created.getTime() <= last_modified.getTime()) continue block5;
                        last_modified = created;
                        continue block5;
                    }
                    catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                triples.close();
            }
        }
        return last_modified;
    }

    public static boolean isInferred(Statement stmt) {
        try {
            Method m = stmt.getClass().getMethod("isInferred", new Class[0]);
            return (Boolean)m.invoke((Object)stmt, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    public static boolean isInferred(RepositoryConnection conn, Statement stmt) throws RepositoryException {
        try {
            Method m = stmt.getClass().getMethod("isInferred", new Class[0]);
            return (Boolean)m.invoke((Object)stmt, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            boolean is_base = conn.hasStatement(stmt, false, new Resource[0]);
            boolean exists = conn.hasStatement(stmt, true, new Resource[0]);
            return !is_base && exists;
        }
    }

    public static boolean isDeleted(RepositoryConnection conn, Statement stmt) throws RepositoryException {
        try {
            Method m = stmt.getClass().getMethod("isDeleted", new Class[0]);
            return (Boolean)m.invoke((Object)stmt, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            boolean exists = conn.hasStatement(stmt, true, new Resource[0]);
            return !exists;
        }
    }

    public static long getId(Statement stmt) {
        try {
            Method m = stmt.getClass().getMethod("getId", new Class[0]);
            return (Long)m.invoke((Object)stmt, new Object[0]);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return 0L;
        }
    }
}

