/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;

public class DateUtils {
    public static final SimpleDateFormat ISO8601FORMAT = DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "UTC");
    public static final SimpleDateFormat ISO8601FORMAT_TIME = DateUtils.createDateFormat("HH:mm:ss.SSS'Z'", "UTC");
    public static final SimpleDateFormat ISO8601FORMAT_DATE = DateUtils.createDateFormat("yyyy-MM-dd", "UTC");
    public static final SimpleDateFormat FILENAME_FORMAT = DateUtils.createDateFormat("yyyyMMdd-HHmmss", null);
    public static final SimpleDateFormat GMTFORMAT = DateUtils.createDateFormat("EEE, dd MMM yyyy HH:mm:ss z", "GMT");
    private static DatatypeFactory datatypeFactory;
    private static final DateFormat[] iso8601InputFormats;

    private static SimpleDateFormat createDateFormat(String format, String timezone) {
        SimpleDateFormat sdf = new SimpleDateFormat(format, DateFormatSymbols.getInstance(Locale.US));
        if (timezone != null) {
            sdf.setTimeZone(TimeZone.getTimeZone(timezone));
        }
        return sdf;
    }

    private static DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        if (datatypeFactory == null) {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        return datatypeFactory;
    }

    public static synchronized Date parseDate(String date) {
        if (date == null) {
            return null;
        }
        int n = date.length();
        if (n > 2 && date.charAt(n - 3) == ':' && (date.charAt(n - 6) == '+' || date.charAt(n - 6) == '-')) {
            date = date.substring(0, n - 3) + date.substring(n - 2);
        }
        for (DateFormat format : iso8601InputFormats) {
            try {
                return format.parse(date);
            }
            catch (ParseException ignore) {
            }
        }
        return null;
    }

    public static Date getDate(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar getXMLCalendar(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.setTime(date);
        try {
            return DateUtils.getDatatypeFactory().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }

    public static XMLGregorianCalendar getXMLCalendar(DateTime date) {
        GregorianCalendar c = date.toGregorianCalendar();
        try {
            return DateUtils.getDatatypeFactory().newXMLGregorianCalendar(c);
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }

    static {
        iso8601InputFormats = new DateFormat[]{ISO8601FORMAT, DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", null), DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", "UTC"), DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", null), DateUtils.createDateFormat("yyyy-MM-dd'T'HH:mm:ss", null), DateUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss'Z'", "UTC"), DateUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ssZ", null), DateUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss.SZ", null), DateUtils.createDateFormat("yyyy-MM-dd' 'HH:mm:ss", null), GMTFORMAT, DateUtils.createDateFormat("EEE, dd MMM yyyy HH:mm:ss'Z'", "GMT"), DateUtils.createDateFormat("EEE MMM dd HH:mm:ss z yyyy", null), DateUtils.createDateFormat("EEE MMM d HH:mm:ss z yyyy", null), DateUtils.createDateFormat("dd.MM.yyy' 'HH:mm:ss", null), DateUtils.createDateFormat("dd.MM.yyy' 'HH:mm", null), ISO8601FORMAT_DATE, DateUtils.createDateFormat("yyyy-MM-ddX", null)};
    }
}

