/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class JSONUtils {
    private static final String VALUE = "value";
    private static final String TYPE = "type";
    private static final String BNODE = "bnode";
    private static final String URI = "uri";
    private static final String LITERAL = "literal";
    private static final String LANG = "lang";
    private static final String DATATYPE = "datatype";

    public static Map<String, String> serializeNodeAsJson(Value node) {
        HashMap<String, String> nodeRep = new HashMap<String, String>();
        if (node instanceof Literal) {
            Literal literal = (Literal)node;
            nodeRep.put(TYPE, LITERAL);
            nodeRep.put(VALUE, literal.stringValue());
            if (literal.getDatatype() != null) {
                nodeRep.put(DATATYPE, literal.getDatatype().stringValue());
            }
            if (literal.getLanguage() != null) {
                nodeRep.put(LANG, literal.getLanguage());
            }
        } else if (node instanceof URI) {
            nodeRep.put(TYPE, URI);
            nodeRep.put(VALUE, node.stringValue());
        } else if (node instanceof BNode) {
            nodeRep.put(TYPE, BNODE);
            nodeRep.put(VALUE, node.stringValue());
        }
        return nodeRep;
    }

    public static Set<Map<String, String>> serializeNodesAsJson(Iterable<? extends Value> nodes) {
        HashSet<Map<String, String>> result = new HashSet<Map<String, String>>();
        for (Value value : nodes) {
            result.add(JSONUtils.serializeNodeAsJson(value));
        }
        return result;
    }

    public static Map<String, ?> serializeTripleAsJson(Statement triple) {
        Set<Map<String, String>> objects;
        Map predicates;
        HashMap subjects = new HashMap();
        String subjectKey = triple.getSubject().stringValue();
        if (subjects.containsKey(subjectKey)) {
            predicates = (Map)subjects.get(subjectKey);
        } else {
            predicates = new HashMap();
            subjects.put(subjectKey, predicates);
        }
        String predicateKey = triple.getPredicate().stringValue();
        if (predicates.containsKey(predicateKey)) {
            objects = (Set)predicates.get(predicateKey);
        } else {
            objects = new HashSet();
            predicates.put(predicateKey, objects);
        }
        objects.add(JSONUtils.serializeNodeAsJson(triple.getObject()));
        return subjects;
    }

    public static Map<String, ?> serializeTriplesAsJson(Iterable<? extends Statement> triples) {
        HashMap subjects = new HashMap();
        for (Statement statement : triples) {
            Set<Map<String, String>> objects;
            Map predicates;
            String subjectKey = statement.getSubject().stringValue();
            if (subjects.containsKey(subjectKey)) {
                predicates = (Map)subjects.get(subjectKey);
            } else {
                predicates = new HashMap();
                subjects.put(subjectKey, predicates);
            }
            String predicateKey = statement.getPredicate().stringValue();
            if (predicates.containsKey(predicateKey)) {
                objects = (Set)predicates.get(predicateKey);
            } else {
                objects = new HashSet();
                predicates.put(predicateKey, objects);
            }
            objects.add(JSONUtils.serializeNodeAsJson(statement.getObject()));
        }
        return subjects;
    }
}

