/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.apache.marmotta.ldpath.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextFilterFunction<Node>
extends SelectorFunction<Node> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final StringTransformer<Node> transformer = new StringTransformer();

    @Override
    public Collection<Node> apply(RDFBackend<Node> rdfBackend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        if (args.length < 1) {
            this.log.debug("filter text from context {}", context);
            return java.util.Collections.singleton(rdfBackend.createLiteral(this.doFilter((String)this.transformer.transform((RDFBackend)rdfBackend, (Object)context, (Map)null))));
        }
        this.log.debug("filter text from parameters");
        Iterator<Node> it = Collections.iterator(args);
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            result.add(rdfBackend.createLiteral(this.doFilter((String)this.transformer.transform((RDFBackend)rdfBackend, (Object)it.next(), (Map)null))));
        }
        return result;
    }

    protected abstract String doFilter(String var1);

    @Override
    public final String getSignature() {
        return String.format("fn:%s(content: LiteralList) : LiteralList", this.getLocalName());
    }
}

