/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.tests;

import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;
import org.apache.marmotta.ldpath.api.tests.NodeTest;

public class PathEqualityTest<Node>
extends NodeTest<Node> {
    private final NodeSelector<Node> path;
    protected final Node node;

    public PathEqualityTest(NodeSelector<Node> path, Node node) {
        this.node = node;
        this.path = path;
    }

    @Override
    public boolean accept(RDFBackend<Node> rdfBackend, Node context, Node candidate) throws IllegalArgumentException {
        return this.path.select(rdfBackend, candidate, null, null).contains(this.node);
    }

    @Override
    public String getPathExpression(NodeBackend<Node> rdfBackend) {
        if (rdfBackend.isURI(this.node)) {
            return String.format("%s is <%s>", this.path.getPathExpression(rdfBackend), rdfBackend.stringValue(this.node));
        }
        if (rdfBackend.isLiteral(this.node)) {
            return String.format("%s is \"%s\"", this.path.getPathExpression(rdfBackend), rdfBackend.stringValue(this.node));
        }
        return String.format("%s is %s", this.path.getPathExpression(rdfBackend), rdfBackend.stringValue(this.node));
    }

    @Override
    public String getSignature() {
        return "nodes is nodes :: (NodeList,NodeList) -> Boolean";
    }

    @Override
    public String getDescription() {
        return "Tests whether the two node lists intersect";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathEqualityTest that = (PathEqualityTest)o;
        if (this.node != null ? !this.node.equals(that.node) : that.node != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.node != null ? this.node.hashCode() : 0);
        return result;
    }
}

