/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.api.functions.TestFunction;
import org.apache.marmotta.ldpath.model.functions.ConcatenateFunction;
import org.apache.marmotta.ldpath.model.functions.FirstFunction;
import org.apache.marmotta.ldpath.model.functions.LastFunction;
import org.apache.marmotta.ldpath.model.functions.SortFunction;
import org.apache.marmotta.ldpath.model.transformers.BigDecimalTransformer;
import org.apache.marmotta.ldpath.model.transformers.BigIntegerTransformer;
import org.apache.marmotta.ldpath.model.transformers.BooleanTransformer;
import org.apache.marmotta.ldpath.model.transformers.ByteTransformer;
import org.apache.marmotta.ldpath.model.transformers.DateTimeTransformer;
import org.apache.marmotta.ldpath.model.transformers.DateTransformer;
import org.apache.marmotta.ldpath.model.transformers.DoubleTransformer;
import org.apache.marmotta.ldpath.model.transformers.DurationTransformer;
import org.apache.marmotta.ldpath.model.transformers.FloatTransformer;
import org.apache.marmotta.ldpath.model.transformers.IntTransformer;
import org.apache.marmotta.ldpath.model.transformers.LongTransformer;
import org.apache.marmotta.ldpath.model.transformers.ShortTransformer;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.apache.marmotta.ldpath.model.transformers.TimeTransformer;
import org.apache.marmotta.ldpath.parser.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfiguration<Node>
extends Configuration<Node> {
    private static Logger log = LoggerFactory.getLogger(DefaultConfiguration.class);
    private static ServiceLoader<SelectorFunction> functionLoader = ServiceLoader.load(SelectorFunction.class, DefaultConfiguration.class.getClassLoader());
    private static ServiceLoader<TestFunction> testLoader = ServiceLoader.load(TestFunction.class, DefaultConfiguration.class.getClassLoader());
    public static final Map<String, String> DEFAULT_NAMESPACES;
    public static final Set<Class<?>> DEFAULT_FUNCTIONS;

    public DefaultConfiguration() {
        this.addDefaultNamespaces();
        this.addDefaultTransformers();
        this.addDefaultFunctions();
        this.addDefaultTestFunctions();
    }

    private void addDefaultNamespaces() {
        this.namespaces.putAll(DEFAULT_NAMESPACES);
    }

    private void addDefaultTransformers() {
        this.addTransformer("http://www.w3.org/2001/XMLSchema#decimal", new BigDecimalTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#integer", new BigIntegerTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#long", new LongTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#int", new IntTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#short", new ShortTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#byte", new ByteTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#double", new DoubleTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#float", new FloatTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#dateTime", new DateTimeTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#date", new DateTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#time", new TimeTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#boolean", new BooleanTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#anyURI", new StringTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#string", new StringTransformer());
        this.addTransformer("http://www.w3.org/2001/XMLSchema#duration", new DurationTransformer());
    }

    private void addDefaultFunctions() {
        Iterator<SelectorFunction> functions = functionLoader.iterator();
        while (functions.hasNext()) {
            try {
                SelectorFunction f = functions.next();
                log.info("registering LDPath function: {}", (Object)f.getSignature());
                this.addFunction(f);
            }
            catch (ServiceConfigurationError e) {
                log.warn("Unable to load function because of an " + e.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    private void addFunction(SelectorFunction<Node> function) {
        this.addFunction("http://www.newmedialab.at/lmf/functions/1.0/" + function.getPathExpression(null), function);
    }

    private void addDefaultTestFunctions() {
        Iterator<TestFunction> testFunctions = testLoader.iterator();
        while (testFunctions.hasNext()) {
            try {
                TestFunction testFunction = testFunctions.next();
                log.info("registering LDPath test function: {}", (Object)testFunction.getSignature());
                this.addTestFunction(testFunction);
            }
            catch (ServiceConfigurationError e) {
                log.warn("Unable to load function because of an " + e.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    private void addTestFunction(TestFunction<Node> test) {
        this.addTestFunction("http://www.newmedialab.at/lmf/functions/1.0/" + test.getLocalName(), test);
    }

    static {
        HashMap<String, String> defNS = new HashMap<String, String>();
        defNS.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        defNS.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        defNS.put("owl", "http://www.w3.org/2002/07/owl#");
        defNS.put("skos", "http://www.w3.org/2004/02/skos/core#");
        defNS.put("foaf", "http://xmlns.com/foaf/0.1/");
        defNS.put("dc", "http://purl.org/dc/elements/1.1/");
        defNS.put("dct", "http://purl.org/dc/terms/");
        defNS.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        defNS.put("lmf", "http://www.newmedialab.at/lmf/types/1.0/");
        defNS.put("fn", "http://www.newmedialab.at/lmf/functions/1.0/");
        DEFAULT_NAMESPACES = Collections.unmodifiableMap(defNS);
        DEFAULT_FUNCTIONS = new HashSet();
        DEFAULT_FUNCTIONS.add(ConcatenateFunction.class);
        DEFAULT_FUNCTIONS.add(FirstFunction.class);
        DEFAULT_FUNCTIONS.add(LastFunction.class);
        DEFAULT_FUNCTIONS.add(SortFunction.class);
    }
}

