/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.ldpath;

import java.util.Collections;
import java.util.List;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.api.provider.DataProvider;
import org.apache.marmotta.ldclient.endpoint.rdf.LinkedDataEndpoint;
import org.apache.marmotta.ldclient.model.ClientConfiguration;
import org.apache.marmotta.ldclient.provider.rdf.CacheProvider;
import org.apache.marmotta.ldclient.provider.rdf.LinkedDataProvider;
import org.apache.marmotta.ldclient.provider.rdf.RegexUriProvider;
import org.apache.marmotta.ldclient.provider.rdf.SPARQLProvider;

public class ClientFactory {
    public static ClientConfiguration createClient(Endpoint endpoint) {
        return ClientFactory.createClient(Collections.singletonList(endpoint), Collections.emptyList());
    }

    public static ClientConfiguration createClient(DataProvider provider) {
        return ClientFactory.createClient(null, null, Collections.emptyList(), Collections.singletonList(provider));
    }

    public static ClientConfiguration createClient(Endpoint endpoint, DataProvider provider) {
        return ClientFactory.createClient(Collections.singletonList(endpoint), Collections.singletonList(provider));
    }

    public static ClientConfiguration createClient(List<Endpoint> endpoints, List<DataProvider> providers) {
        return ClientFactory.createClient(null, null, endpoints, providers);
    }

    public static ClientConfiguration createClient(AuthScope authScope, Credentials credentials) {
        return ClientFactory.createClient(authScope, credentials, Collections.emptyList(), Collections.emptyList());
    }

    public static ClientConfiguration createClient(AuthScope authScope, Credentials credentials, List<Endpoint> endpoints, List<DataProvider> providers) {
        ClientConfiguration client = new ClientConfiguration();
        if (credentials != null && authScope != null) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(authScope, credentials);
            client.setHttpClient((HttpClient)HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).useSystemProperties().build());
        }
        client.addProvider((DataProvider)((Object)new LinkedDataProvider()));
        client.addProvider((DataProvider)((Object)new CacheProvider()));
        client.addProvider((DataProvider)((Object)new RegexUriProvider()));
        client.addProvider((DataProvider)((Object)new SPARQLProvider()));
        client.addEndpoint(new LinkedDataEndpoint());
        endpoints.forEach(client::addEndpoint);
        providers.forEach(client::addProvider);
        return client;
    }

    private ClientFactory() {
    }
}

