/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.collection;

import java.util.Iterator;
import javolution.util.function.Equality;
import javolution.util.internal.collection.CollectionView;
import javolution.util.service.CollectionService;

public class UnmodifiableCollectionImpl<E>
extends CollectionView<E> {
    private static final long serialVersionUID = 1536L;

    public UnmodifiableCollectionImpl(CollectionService<E> target) {
        super(target);
    }

    @Override
    public boolean add(E element) {
        throw new UnsupportedOperationException("Read-Only Collection.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Read-Only Collection.");
    }

    @Override
    public Equality<? super E> comparator() {
        return this.target().comparator();
    }

    @Override
    public boolean contains(Object obj) {
        return this.target().contains(obj);
    }

    @Override
    public boolean isEmpty() {
        return this.target().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new IteratorImpl();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Read-Only Collection.");
    }

    @Override
    public int size() {
        return this.target().size();
    }

    @Override
    public CollectionService<E>[] split(int n, boolean updateable) {
        CollectionService[] subTargets = (CollectionService[])this.target().split(n, updateable);
        CollectionService[] result = new CollectionService[subTargets.length];
        for (int i = 0; i < subTargets.length; ++i) {
            result[i] = new UnmodifiableCollectionImpl<E>(subTargets[i]);
        }
        return result;
    }

    private class IteratorImpl
    implements Iterator<E> {
        private final Iterator<E> targetIterator;

        private IteratorImpl() {
            this.targetIterator = UnmodifiableCollectionImpl.this.target().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.targetIterator.hasNext();
        }

        @Override
        public E next() {
            return this.targetIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-Only Collection.");
        }
    }
}

