/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.comparator;

import javolution.lang.MathLib;
import javolution.util.function.Equality;

public class LexicalComparatorImpl
implements Equality<CharSequence> {
    private static final long serialVersionUID = 7904852144917623728L;

    @Override
    public boolean areEqual(CharSequence csq1, CharSequence csq2) {
        if (csq1 == csq2) {
            return true;
        }
        if (csq1 == null || csq2 == null) {
            return false;
        }
        if (csq1 instanceof String) {
            if (csq2 instanceof String) {
                return csq1.equals(csq2);
            }
            return ((String)csq1).contentEquals(csq2);
        }
        if (csq2 instanceof String) {
            return ((String)csq2).contentEquals(csq1);
        }
        int n = csq1.length();
        if (csq2.length() != n) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (csq1.charAt(i) == csq2.charAt(i++)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compare(CharSequence left, CharSequence right) {
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left instanceof String && right instanceof String) {
            return ((String)left).compareTo((String)right);
        }
        int i = 0;
        int n = MathLib.min(left.length(), right.length());
        while (n-- != 0) {
            char c2;
            char c1 = left.charAt(i);
            if (c1 == (c2 = right.charAt(i++))) continue;
            return c1 - c2;
        }
        return left.length() - right.length();
    }

    @Override
    public int hashCodeOf(CharSequence csq) {
        if (csq == null) {
            return 0;
        }
        if (csq instanceof String) {
            return csq.hashCode();
        }
        int h = 0;
        int i = 0;
        int n = csq.length();
        while (i < n) {
            h = 31 * h + csq.charAt(i++);
        }
        return h;
    }
}

