/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.internal.map;

import java.util.Iterator;
import java.util.Map;
import javolution.util.function.Equality;
import javolution.util.internal.ReadWriteLockImpl;
import javolution.util.internal.map.MapView;
import javolution.util.service.MapService;

public class SharedMapImpl<K, V>
extends MapView<K, V> {
    private static final long serialVersionUID = 1536L;
    protected ReadWriteLockImpl lock;
    protected transient Thread updatingThread;

    public SharedMapImpl(MapService<K, V> target) {
        this(target, new ReadWriteLockImpl());
    }

    public SharedMapImpl(MapService<K, V> target, ReadWriteLockImpl lock) {
        super(target);
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.writeLock.lock();
        try {
            this.target().clear();
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        this.lock.readLock.lock();
        try {
            boolean bl = this.target().containsKey(key);
            return bl;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        this.lock.readLock.lock();
        try {
            boolean bl = this.target().containsValue(value);
            return bl;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        this.lock.readLock.lock();
        try {
            Object v = this.target().get(key);
            return v;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.lock.readLock.lock();
        try {
            boolean bl = this.target().isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new IteratorImpl();
    }

    @Override
    public Equality<? super K> keyComparator() {
        return this.target().keyComparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.lock.writeLock.lock();
        try {
            V v = this.target().put(key, value);
            return v;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.lock.writeLock.lock();
        try {
            this.target().putAll(m);
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.lock.writeLock.lock();
        try {
            V v = this.target().putIfAbsent(key, value);
            return v;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        this.lock.writeLock.lock();
        try {
            Object v = this.target().remove(key);
            return v;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().remove(key, value);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.lock.writeLock.lock();
        try {
            V v = this.target().replace(key, value);
            return v;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.lock.writeLock.lock();
        try {
            boolean bl = this.target().replace(key, oldValue, newValue);
            return bl;
        }
        finally {
            this.lock.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.readLock.lock();
        try {
            int n = this.target().size();
            return n;
        }
        finally {
            this.lock.readLock.unlock();
        }
    }

    @Override
    public Equality<? super V> valueComparator() {
        return this.target().valueComparator();
    }

    protected MapService<K, V> cloneTarget() {
        try {
            return this.target().clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Cannot happen since target is Cloneable.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapService<K, V>[] split(int n, boolean updateable) {
        MapService[] tmp;
        this.lock.readLock.lock();
        try {
            tmp = (MapService[])this.target().split(n, updateable);
        }
        finally {
            this.lock.readLock.unlock();
        }
        MapService[] result = new MapService[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            result[i] = new SharedMapImpl<K, V>(tmp[i], this.lock);
        }
        return result;
    }

    private class IteratorImpl
    implements Iterator<Map.Entry<K, V>> {
        private Map.Entry<K, V> next;
        private final Iterator<Map.Entry<K, V>> targetIterator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IteratorImpl() {
            SharedMapImpl.this.lock.readLock.lock();
            try {
                this.targetIterator = SharedMapImpl.this.cloneTarget().entrySet().iterator();
            }
            finally {
                SharedMapImpl.this.lock.readLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.targetIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.next = this.targetIterator.next();
            return this.next;
        }

        @Override
        public void remove() {
            if (this.next == null) {
                throw new IllegalStateException();
            }
            SharedMapImpl.this.remove(this.next.getKey());
            this.next = null;
        }
    }
}

