/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.model;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.joda.time.DateTime;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class LiteralCommons {
    private static final int HASH_BITS = 128;
    private static DatatypeFactory dtf;

    public static String createCacheKey(String content, Locale language, URI type) {
        return LiteralCommons.createCacheKey(content, language != null ? language.getLanguage() : null, type != null ? type.stringValue() : null);
    }

    public static String createCacheKey(String content, Locale language, String type) {
        return LiteralCommons.createCacheKey(content, language != null ? language.getLanguage() : null, type);
    }

    public static String createCacheKey(DateTime date, String type) {
        GregorianCalendar cal = date.toGregorianCalendar();
        XMLGregorianCalendar xml_cal = dtf.newXMLGregorianCalendar(cal);
        return LiteralCommons.createCacheKey(xml_cal.toXMLFormat(), (String)null, type);
    }

    public static String createCacheKey(Literal l) {
        return LiteralCommons.createCacheKey(l.getLabel(), l.getLanguage(), l.getDatatype() != null ? l.getDatatype().stringValue() : null);
    }

    public static String createCacheKey(String content, String language, String type) {
        Hasher hasher = Hashing.goodFastHash((int)128).newHasher();
        hasher.putString((CharSequence)content, Charset.defaultCharset());
        if (type != null) {
            hasher.putString((CharSequence)type, Charset.defaultCharset());
        }
        if (language != null) {
            hasher.putString((CharSequence)language.toLowerCase(), Charset.defaultCharset());
        }
        return hasher.hash().toString();
    }

    public static String getXSDType(Class<?> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return "http://www.w3.org/2001/XMLSchema#string";
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return "http://www.w3.org/2001/XMLSchema#integer";
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return "http://www.w3.org/2001/XMLSchema#long";
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return "http://www.w3.org/2001/XMLSchema#double";
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return "http://www.w3.org/2001/XMLSchema#float";
        }
        if (Date.class.isAssignableFrom(clazz) || DateTime.class.isAssignableFrom(clazz)) {
            return "http://www.w3.org/2001/XMLSchema#dateTime";
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return "http://www.w3.org/2001/XMLSchema#boolean";
        }
        return null;
    }

    public static String getRDFLangStringType() {
        return "http://www.w3.org/1999/02/22-rdf-syntax-ns#langString";
    }

    private LiteralCommons() {
    }

    static {
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            // empty catch block
        }
    }
}

