/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.rdf;

import info.aduna.lang.FileFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javolution.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.marmotta.commons.sesame.model.ModelCommons;
import org.apache.marmotta.ldclient.exception.DataRetrievalException;
import org.apache.marmotta.ldclient.services.provider.AbstractHttpProvider;
import org.openrdf.model.Model;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParserRegistry;

public abstract class AbstractRDFProvider
extends AbstractHttpProvider {
    public String[] listMimeTypes() {
        return new String[]{"application/rdf+xml", "text/rdf+n3; q=0.8", "text/turtle; q=0.6"};
    }

    public List<String> parseResponse(final String resourceUri, String requestUrl, Model triples, InputStream in, String contentType) throws DataRetrievalException {
        RDFFormat format = (RDFFormat)RDFParserRegistry.getInstance().getFileFormatForMIMEType(contentType, (FileFormat)RDFFormat.RDFXML);
        try {
            ModelCommons.add(triples, in, resourceUri, format, new Predicate<Statement>(){

                @Override
                public boolean test(Statement param) {
                    return StringUtils.equals((CharSequence)param.getSubject().stringValue(), (CharSequence)resourceUri);
                }
            });
            return Collections.emptyList();
        }
        catch (RDFParseException e) {
            throw new DataRetrievalException("parse error while trying to parse remote RDF content", e);
        }
        catch (IOException e) {
            throw new DataRetrievalException("I/O error while trying to read remote RDF content", e);
        }
    }
}

