/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.rdf;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.exception.DataRetrievalException;
import org.apache.marmotta.ldclient.services.provider.AbstractHttpProvider;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPARQLProvider
extends AbstractHttpProvider {
    public static final String PROVIDER_NAME = "SPARQL";
    private static Logger log = LoggerFactory.getLogger(SPARQLProvider.class);

    public String getName() {
        return PROVIDER_NAME;
    }

    public String[] listMimeTypes() {
        return new String[]{"application/sparql-results+xml"};
    }

    public List<String> buildRequestUrl(String resourceUri, Endpoint endpoint) {
        Preconditions.checkNotNull((Object)resourceUri);
        Preconditions.checkNotNull((Object)endpoint);
        try {
            String contentType = "application/sparql-results+xml";
            if (endpoint.getContentTypes().size() > 0) {
                contentType = endpoint.getContentTypes().iterator().next().toStringNoParameters();
            }
            String query = "SELECT ?p ?o WHERE { <{uri}> ?p ?o }";
            String url = endpoint.getEndpointUrl().replace("{query}", URLEncoder.encode(query.replace("{uri}", resourceUri), "UTF-8")).replace("{contenttype}", URLEncoder.encode(contentType, "UTF-8"));
            return Collections.singletonList(url);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding UTF-8 not supported; the Java environment is severely broken");
        }
    }

    public List<String> parseResponse(final String resourceUri, String requestUrl, final Model triples, InputStream in, String contentType) throws DataRetrievalException {
        TupleQueryResultFormat format = QueryResultIO.getParserFormatForMIMEType((String)contentType, (TupleQueryResultFormat)TupleQueryResultFormat.SPARQL);
        try {
            QueryResultIO.parse((InputStream)in, (TupleQueryResultFormat)format, (TupleQueryResultHandler)new TupleQueryResultHandler(){
                URI subject;

                public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
                    this.subject = ValueFactoryImpl.getInstance().createURI(resourceUri);
                }

                public void endQueryResult() throws TupleQueryResultHandlerException {
                }

                public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
                    Value predicate = bindingSet.getValue("p");
                    Value object = bindingSet.getValue("o");
                    if (predicate instanceof URI) {
                        triples.add((Object)ValueFactoryImpl.getInstance().createStatement((Resource)this.subject, (URI)predicate, object));
                    } else {
                        log.error("ignoring binding as predicate {} is not a URI", (Object)predicate);
                    }
                }

                public void handleBoolean(boolean bool) throws QueryResultHandlerException {
                }

                public void handleLinks(List<String> links) throws QueryResultHandlerException {
                }
            }, (ValueFactory)ValueFactoryImpl.getInstance());
            return Collections.emptyList();
        }
        catch (QueryResultParseException e) {
            throw new DataRetrievalException("parse error while trying to parse remote SPARQL results", e);
        }
        catch (TupleQueryResultHandlerException e) {
            throw new DataRetrievalException("parse error while trying to parse remote SPARQL results", e);
        }
        catch (IOException e) {
            throw new DataRetrievalException("I/O error while trying to read remote RDF content", e);
        }
    }
}

