/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.backend.linkeddata;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.concurrent.ThreadPoolExecutor;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.marmotta.ldcache.api.LDCachingBackend;
import org.apache.marmotta.ldcache.api.LDCachingService;
import org.apache.marmotta.ldcache.backend.infinispan.LDCachingInfinispanBackend;
import org.apache.marmotta.ldcache.model.CacheConfiguration;
import org.apache.marmotta.ldcache.services.LDCache;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDCacheBackend
implements RDFBackend<Value> {
    private static final Logger log = LoggerFactory.getLogger(LDCacheBackend.class);
    private LDCache ldcache;

    public LDCacheBackend() {
        LDCachingInfinispanBackend backend = new LDCachingInfinispanBackend();
        backend.initialize();
        this.ldcache = new LDCache(new CacheConfiguration(), (LDCachingBackend)backend);
    }

    public LDCacheBackend(LDCache ldcache) {
        this.ldcache = ldcache;
    }

    @Override
    public boolean isLiteral(Value n) {
        return n instanceof Literal;
    }

    @Override
    public boolean isURI(Value n) {
        return n instanceof org.openrdf.model.URI;
    }

    @Override
    public boolean isBlank(Value n) {
        return n instanceof BNode;
    }

    @Override
    public Locale getLiteralLanguage(Value n) {
        try {
            if (((Literal)n).getLanguage() != null) {
                return new Locale(((Literal)n).getLanguage());
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + n.stringValue() + " is not a literal" + "but of type " + this.debugType(n));
        }
    }

    @Override
    public URI getLiteralType(Value n) {
        try {
            if (((Literal)n).getDatatype() != null) {
                try {
                    return new URI(((Literal)n).getDatatype().stringValue());
                }
                catch (URISyntaxException e) {
                    log.error("literal datatype was not a valid URI: {}", (Object)((Literal)n).getDatatype());
                    return null;
                }
            }
            return null;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + n.stringValue() + " is not a literal" + "but of type " + this.debugType(n));
        }
    }

    @Override
    public String stringValue(Value value) {
        return value.stringValue();
    }

    @Override
    public BigDecimal decimalValue(Value node) {
        try {
            return ((Literal)node).decimalValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    @Override
    public BigInteger integerValue(Value node) {
        try {
            return ((Literal)node).integerValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    @Override
    public Boolean booleanValue(Value node) {
        try {
            return ((Literal)node).booleanValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    @Override
    public Date dateTimeValue(Value node) {
        try {
            XMLGregorianCalendar cal = ((Literal)node).calendarValue();
            return cal.toGregorianCalendar().getTime();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    @Override
    public Date dateValue(Value node) {
        try {
            XMLGregorianCalendar cal = ((Literal)node).calendarValue();
            return new GregorianCalendar(cal.getYear(), cal.getMonth(), cal.getDay()).getTime();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    @Override
    public Date timeValue(Value node) {
        return this.dateTimeValue(node);
    }

    @Override
    public Long longValue(Value node) {
        try {
            return ((Literal)node).longValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    @Override
    public Double doubleValue(Value node) {
        try {
            return ((Literal)node).doubleValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    @Override
    public Float floatValue(Value node) {
        try {
            return Float.valueOf(((Literal)node).floatValue());
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    @Override
    public Integer intValue(Value node) {
        try {
            return ((Literal)node).intValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value " + node.stringValue() + " is not a literal" + "but of type " + this.debugType(node));
        }
    }

    protected String debugType(Value value) {
        return value == null ? "null" : (this.isURI(value) ? "URI" : (this.isBlank(value) ? "bNode" : "literal (" + this.getLiteralType(value) + ")"));
    }

    @Override
    public Literal createLiteral(String content) {
        return new LiteralImpl(content);
    }

    @Override
    public Literal createLiteral(String content, Locale language, URI type) {
        log.debug("creating literal with content \"{}\", language {}, datatype {}", new Object[]{content, language, type});
        if (language == null && type == null) {
            return this.createLiteral(content);
        }
        if (type == null) {
            return new LiteralImpl(content, language.getLanguage());
        }
        return new LiteralImpl(content, this.createURI(type.toString()));
    }

    @Override
    public org.openrdf.model.URI createURI(String uri) {
        return new URIImpl(uri);
    }

    @Override
    public boolean supportsThreading() {
        return false;
    }

    @Override
    public ThreadPoolExecutor getThreadPool() {
        return null;
    }

    @Override
    public Collection<Value> listObjects(Value subject, Value property) {
        log.info("retrieving resource {}", (Object)subject);
        if (subject instanceof org.openrdf.model.URI && subject instanceof org.openrdf.model.URI) {
            org.openrdf.model.URI s = (org.openrdf.model.URI)subject;
            org.openrdf.model.URI p = (org.openrdf.model.URI)property;
            return this.ldcache.get(s, new LDCachingService.RefreshOpts[0]).filter((Resource)s, p, null, new Resource[0]).objects();
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Value> listSubjects(Value property, Value object) {
        throw new UnsupportedOperationException("reverse traversal not supported for Linked Data backend");
    }
}

