/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.ldpath;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.provider.rdf.LinkedDataProvider;
import org.fcrepo.client.FcrepoHttpClientBuilder;
import org.fcrepo.client.FcrepoLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraProvider
extends LinkedDataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraProvider.class);
    public static final String PROVIDER_NAME = "Fedora";
    private final HttpClient httpClient;
    private final String NON_RDF_SOURCE_URI = "http://www.w3.org/ns/ldp#NonRDFSource";

    public FedoraProvider(FcrepoHttpClientBuilder builder) {
        Objects.requireNonNull(builder);
        this.httpClient = builder.build();
    }

    @Override
    public String getName() {
        return PROVIDER_NAME;
    }

    @Override
    public List<String> buildRequestUrl(String resourceUri, Endpoint endpoint) {
        LOGGER.debug("Processing: " + resourceUri);
        Objects.requireNonNull(resourceUri);
        try {
            Optional<String> nonRdfSourceDescUri = this.getNonRDFSourceDescribedByUri(resourceUri);
            if (nonRdfSourceDescUri.isPresent()) {
                return Collections.singletonList(nonRdfSourceDescUri.get());
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return Collections.singletonList(resourceUri);
    }

    private Optional<String> getNonRDFSourceDescribedByUri(String resourceUri) throws IOException {
        Optional<String> nonRdfSourceDescUri = Optional.empty();
        Header[] links = this.getLinkHeaders(resourceUri);
        if (links != null) {
            String descriptionUri = null;
            boolean isNonRDFSource = false;
            for (Header h : links) {
                FcrepoLink link = new FcrepoLink(h.getValue());
                if (link.getRel().equals("describedby")) {
                    descriptionUri = link.getUri().toString();
                    continue;
                }
                if (!link.getUri().toString().contains("http://www.w3.org/ns/ldp#NonRDFSource")) continue;
                isNonRDFSource = true;
            }
            LOGGER.debug("isNonRDFSource: " + isNonRDFSource);
            if (isNonRDFSource && descriptionUri != null) {
                nonRdfSourceDescUri = Optional.of(descriptionUri);
            }
        }
        return nonRdfSourceDescUri;
    }

    private Header[] getLinkHeaders(String resourceUri) throws IOException {
        HttpHead request = new HttpHead(resourceUri);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        LOGGER.debug("Got: " + response.getStatusLine().getStatusCode() + " for HEAD " + resourceUri);
        return response.getHeaders("Link");
    }
}

