/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.ldpath;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.marmotta.ldcache.api.LDCachingBackend;
import org.apache.marmotta.ldcache.backend.file.LDCachingFileBackend;
import org.apache.marmotta.ldcache.model.CacheConfiguration;
import org.apache.marmotta.ldcache.services.LDCache;
import org.apache.marmotta.ldclient.api.endpoint.Endpoint;
import org.apache.marmotta.ldclient.model.ClientConfiguration;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.backend.linkeddata.LDCacheBackend;
import org.fcrepo.camel.common.config.BasePropsConfig;
import org.fcrepo.camel.ldpath.ClientFactory;
import org.fcrepo.camel.ldpath.FedoraEndpoint;
import org.fcrepo.camel.ldpath.FedoraProvider;
import org.fcrepo.camel.ldpath.LDPathRouter;
import org.fcrepo.camel.ldpath.LDPathWrapper;
import org.fcrepo.client.FcrepoHttpClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FcrepoLdPathConfig
extends BasePropsConfig {
    @Value(value="${ldpath.fcrepo.cache.timeout:0}")
    private long fcrepoCacheTimeout;
    @Value(value="${ldpath.rest.prefix:/ldpath}")
    private String restPrefix;
    @Value(value="${ldpath.rest.host:localhost}")
    private String restHost;
    @Value(value="${ldpath.rest.port:9085}")
    private int restPort;
    @Value(value="${ldpath.cache.timeout:86400}")
    private int cacheTimeout;
    @Value(value="${ldpath.ldcache.directory:ldcache/}")
    private Path ldCacheDirectory;
    @Value(value="${ldpath.transform.path:classpath:org/fcrepo/camel/ldpath/default.ldpath}")
    private String ldpathTransformPath;

    public String getRestHost() {
        return this.restHost;
    }

    public int getRestPort() {
        return this.restPort;
    }

    public String getRestPrefix() {
        return this.restPrefix;
    }

    public String getLdpathTransformPath() {
        return this.ldpathTransformPath;
    }

    @Bean(value={"ldpath"})
    public LDPathWrapper ldpath() throws Exception {
        String fcrepoBaseUrl = this.getFcrepoBaseUrl();
        String fcrepoAuthHost = this.getFcrepoAuthHost();
        String fcrepoUsername = this.getFcrepoUsername();
        String fcrepoPassword = this.getFcrepoPassword();
        AuthScope authScope = fcrepoAuthHost == null || fcrepoAuthHost.isBlank() ? new AuthScope(AuthScope.ANY) : new AuthScope(new HttpHost(fcrepoAuthHost));
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(fcrepoUsername, fcrepoPassword);
        List<Endpoint> endpoints = List.of(new FedoraEndpoint(fcrepoBaseUrl, this.fcrepoCacheTimeout));
        FcrepoHttpClientBuilder fcrepoHttpClientBuilder = new FcrepoHttpClientBuilder(fcrepoUsername, fcrepoPassword, fcrepoAuthHost);
        List<FedoraProvider> providers = List.of(new FedoraProvider(fcrepoHttpClientBuilder));
        ClientConfiguration client = ClientFactory.createClient(authScope, (Credentials)credentials, endpoints, providers);
        CacheConfiguration config = new CacheConfiguration(client);
        config.setDefaultExpiry((long)this.cacheTimeout);
        LDCachingFileBackend ldCachingBackend = new LDCachingFileBackend(this.ldCacheDirectory.toFile());
        ldCachingBackend.initialize();
        LDCache ldCache = new LDCache(config, (LDCachingBackend)ldCachingBackend);
        LDCacheBackend backend = new LDCacheBackend(ldCache);
        return new LDPathWrapper(backend, this.createSelectorFunctions());
    }

    protected Set<SelectorFunction> createSelectorFunctions() {
        return Collections.EMPTY_SET;
    }

    @Bean
    public LDPathRouter ldPathRouter() {
        return new LDPathRouter();
    }
}

