/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.reindexing;

import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.PropertyInject;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.fcrepo.camel.reindexing.PathProcessor;
import org.fcrepo.camel.reindexing.RestProcessor;
import org.fcrepo.camel.reindexing.UsageProcessor;
import org.fcrepo.client.HttpMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexingRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReindexingRouter.class);
    private static final int BAD_REQUEST = 400;
    @PropertyInject(value="rest.port", defaultValue="9080")
    private String port;
    @PropertyInject(value="rest.host", defaultValue="localhost")
    private String host;

    public void configure() throws Exception {
        String hostname = this.host.startsWith("http") ? this.host : "http://" + this.host;
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        ns.add("ldp", "http://www.w3.org/ns/ldp#");
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log("Index Routing Error: ${routeId}");
        ((ChoiceDefinition)this.from("jetty:" + hostname + ":" + this.port + "{{rest.prefix}}?matchOnUriPrefix=true&httpMethodRestrict=GET,POST").routeId("FcrepoReindexingRest").routeDescription("Expose the reindexing endpoint over HTTP").choice().when(this.header("CamelHttpMethod").isEqualTo((Object)"GET")).to("direct:usage")).otherwise().to("direct:reindex");
        ((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:usage").routeId("FcrepoReindexingUsage").setHeader("CamelFcrepoReindexingRestPrefix").simple("{{rest.prefix}}")).setHeader("CamelFcrepoReindexingRestPort").simple(this.port)).setHeader("CamelFcrepoBaseUrl").simple("{{fcrepo.baseUrl}}")).process((Processor)new UsageProcessor());
        ((ProcessorDefinition)((ChoiceDefinition)((ChoiceDefinition)((ProcessorDefinition)((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:reindex").routeId("FcrepoReindexingReindex").setHeader("CamelFcrepoReindexingRestPrefix").simple("{{rest.prefix}}")).setHeader("CamelFcrepoBaseUrl").simple("{{fcrepo.baseUrl}}")).process((Processor)new RestProcessor())).choice().when(this.header("CamelHttpResponseCode").isGreaterThanOrEqualTo((Object)400)).endChoice().when(this.header("CamelFcrepoReindexingRecipients").isEqualTo((Object)"")).transform().simple("No endpoints configured for indexing")).endChoice().otherwise().log(LoggingLevel.INFO, LOGGER, "Initial indexing path: ${headers[CamelFcrepoIdentifier]}")).inOnly("{{reindexing.stream}}?disableTimeToLive=true")).setHeader("Content-Type").constant((Object)"text/plain")).transform().simple("Indexing started at ${headers[CamelFcrepoIdentifier]}");
        ((ExpressionNode)((ProcessorDefinition)((SplitDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("{{reindexing.stream}}?asyncConsumer=true").routeId("FcrepoReindexingTraverse").inOnly("direct:recipients")).removeHeaders("CamelHttp*")).setHeader("CamelHttpMethod").constant((Object)HttpMethods.GET)).to("fcrepo:{{fcrepo.baseUrl}}?preferInclude=PreferContainment&preferOmit=ServerManaged&accept=application/rdf+xml")).convertBodyTo(StreamSource.class)).split().xtokenize("/rdf:RDF/rdf:Description/ldp:contains", 'i', ns)).streaming().transform().xpath("/ldp:contains/@rdf:resource", String.class, ns)).process((Processor)new PathProcessor())).inOnly("{{reindexing.stream}}?disableTimeToLive=true");
        this.from("direct:recipients").routeId("FcrepoReindexingRecipients").recipientList((Expression)this.header("CamelFcrepoReindexingRecipients")).ignoreInvalidEndpoints();
    }
}

