/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.reindexing;

import java.net.InetAddress;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.PropertyInject;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.fcrepo.camel.reindexing.RestProcessor;
import org.fcrepo.client.HttpMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexingRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReindexingRouter.class);
    private static final int BAD_REQUEST = 400;
    private static final String LDP_CONTAINS = "<http://www.w3.org/ns/ldp#contains>";
    @PropertyInject(value="rest.port", defaultValue="9080")
    private String port;
    @PropertyInject(value="rest.host", defaultValue="localhost")
    private String host;

    public void configure() throws Exception {
        String hostname = this.host.startsWith("http") ? this.host : "http://" + this.host;
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log("Index Routing Error: ${routeId}");
        ((ChoiceDefinition)((ProcessorDefinition)this.from("jetty:" + hostname + ":" + this.port + "{{rest.prefix}}?matchOnUriPrefix=true&httpMethodRestrict=GET,POST").routeId("FcrepoReindexingRest").routeDescription("Expose the reindexing endpoint over HTTP").setHeader("CamelFcrepoUri").simple("{{fcrepo.baseUrl}}${headers.CamelHttpPath}")).choice().when(this.header("CamelHttpMethod").isEqualTo((Object)"GET")).to("direct:usage")).otherwise().to("direct:reindex");
        ((RouteDefinition)((ProcessorDefinition)((ProcessorDefinition)((ProcessorDefinition)this.from("direct:usage").routeId("FcrepoReindexingUsage").setHeader("CamelReindexingPrefix").simple("{{rest.prefix}}")).setHeader("CamelReindexingPort").simple(this.port)).setHeader("CamelFcrepoBaseUrl").simple("{{fcrepo.baseUrl}}")).process(exchange -> exchange.getIn().setHeader("CamelReindexingHost", (Object)InetAddress.getLocalHost().getHostName()))).to("mustache:org/fcrepo/camel/reindexing/usage.mustache");
        ((ProcessorDefinition)((ChoiceDefinition)((ChoiceDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:reindex").routeId("FcrepoReindexingReindex").process((Processor)new RestProcessor())).removeHeaders("CamelHttp*")).removeHeader("JMSCorrelationID")).setBody((Expression)this.constant(null))).choice().when(this.header("CamelHttpResponseCode").isGreaterThanOrEqualTo((Object)400)).endChoice().when(this.header("CamelReindexingRecipients").isEqualTo((Object)"")).transform().simple("No endpoints configured for indexing")).endChoice().otherwise().log(LoggingLevel.INFO, LOGGER, "Initial indexing path: ${headers[CamelFcrepoUri]}")).inOnly("{{reindexing.stream}}?disableTimeToLive=true")).setHeader("Content-Type").constant((Object)"text/plain")).transform().simple("Indexing started at ${headers[CamelFcrepoUri]}");
        ((ExpressionNode)((ExpressionNode)((ExpressionNode)((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("{{reindexing.stream}}?asyncConsumer=true").routeId("FcrepoReindexingTraverse").inOnly("direct:recipients")).removeHeaders("CamelHttp*")).setHeader("CamelHttpMethod").constant((Object)HttpMethods.GET)).to("fcrepo:{{fcrepo.baseUrl}}?preferInclude=PreferContainment&preferOmit=ServerManaged&accept=application/n-triples")).split((Expression)this.body().tokenize("\\n")).streaming().removeHeader("CamelFcrepoUri")).removeHeader("JMSCorrelationID")).process(exchange -> {
            String body = (String)exchange.getIn().getBody(String.class);
            if (body != null) {
                String[] parts = body.split("\\s+");
                if (parts.length > 2 && parts[1].equals(LDP_CONTAINS) && parts[2].startsWith("<")) {
                    exchange.getIn().setHeader("CamelFcrepoUri", (Object)parts[2].substring(1, parts[2].length() - 1));
                }
                exchange.getIn().setBody(null);
            }
        })).filter(this.header("CamelFcrepoUri").isNotNull()).inOnly("{{reindexing.stream}}?disableTimeToLive=true");
        this.from("direct:recipients").routeId("FcrepoReindexingRecipients").recipientList((Expression)this.header("CamelReindexingRecipients")).ignoreInvalidEndpoints();
    }
}

