/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.reindexing;

import org.apache.camel.builder.RouteBuilder;
import org.fcrepo.camel.common.config.BasePropsConfig;
import org.fcrepo.camel.common.config.ConditionOnPropertyTrue;
import org.fcrepo.camel.reindexing.ReindexingRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={ReindexingEnabled.class})
public class FcrepoReindexingConfig
extends BasePropsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoReindexingConfig.class);
    static final String REINDEXING_ENABLED = "reindexing.enabled";
    @Value(value="${reindexing.stream:broker:queue:reindexing}")
    private String reindexingStream;
    @Value(value="${reindexing.rest.prefix:/reindexing}")
    private String restPrefix;
    @Value(value="${reindexing.rest.host:localhost}")
    private String restHost;
    @Value(value="${reindexing.rest.port:9080}")
    private int restPort;

    public String getReindexingStream() {
        return this.reindexingStream;
    }

    public String getRestPrefix() {
        return this.restPrefix;
    }

    public String getRestHost() {
        return this.restHost;
    }

    public int getRestPort() {
        return this.restPort;
    }

    @Bean
    public RouteBuilder reindexingRoute() {
        return new ReindexingRouter();
    }

    static class ReindexingEnabled
    extends ConditionOnPropertyTrue {
        ReindexingEnabled() {
            super(FcrepoReindexingConfig.REINDEXING_ENABLED, true);
        }
    }
}

