/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.reindexing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestProcessor.class);
    private static final int BAD_REQUEST = 400;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public void process(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        String contentType = (String)in.getHeader("Content-Type", (Object)"", String.class);
        String body = (String)in.getBody(String.class);
        HashSet<String> endpoints = new HashSet<String>();
        for (String s : ((String)in.getHeader("CamelReindexingRecipients", (Object)"", String.class)).split(",")) {
            endpoints.add(s.trim());
        }
        if (contentType.equals("application/json") && body != null && !body.trim().isEmpty()) {
            try {
                JsonNode root = MAPPER.readTree(body);
                Iterator ite = root.elements();
                while (ite.hasNext()) {
                    JsonNode n = (JsonNode)ite.next();
                    endpoints.add(n.asText());
                }
            }
            catch (JsonProcessingException e) {
                LOGGER.debug("Invalid JSON", (Throwable)e);
                in.setHeader("CamelHttpResponseCode", (Object)400);
                in.setBody((Object)"Invalid JSON");
            }
        }
        in.setHeader("CamelReindexingRecipients", (Object)String.join((CharSequence)",", endpoints));
    }
}

