/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.serialization;

import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationRouter.class);
    private static final String isBinaryResourceXPath = "/rdf:RDF/rdf:Description/rdf:type[@rdf:resource=\"http://fedora.info/definitions/v4/repository#Binary\"]";

    public void configure() throws Exception {
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#").add("fedora", "http://fedora.info/definitions/v4/repository#");
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log("Index Routing Error: ${routeId}");
        ((ChoiceDefinition)((ProcessorDefinition)this.from("{{input.stream}}").routeId("FcrepoSerialization").setHeader("CamelFcrepoIdentifier").header("org.fcrepo.jms.identifier")).filter(PredicateBuilder.not((Predicate)PredicateBuilder.or((Predicate)this.header("CamelFcrepoIdentifier").startsWith((Object)this.simple("{{audit.container}}/")), (Predicate)this.header("CamelFcrepoIdentifier").isEqualTo((Object)this.simple("{{audit.container}}"))))).choice().when(this.header("org.fcrepo.jms.eventType").isEqualTo((Object)"http://fedora.info/definitions/v4/repository#NODE_REMOVED")).to("direct:delete")).endChoice().otherwise().multicast().to(new String[]{"direct:metadata", "direct:binary"});
        this.from("{{serialization.stream}}").routeId("FcrepoReSerialization").filter(PredicateBuilder.not((Predicate)PredicateBuilder.or((Predicate)this.header("CamelFcrepoIdentifier").startsWith((Object)this.simple("{{audit.container}}/")), (Predicate)this.header("CamelFcrepoIdentifier").isEqualTo((Object)this.simple("{{audit.container}}"))))).multicast().to(new String[]{"direct:metadata", "direct:binary"});
        ((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:metadata").routeId("FcrepoSerializationMetadataUpdater").to("fcrepo:{{fcrepo.baseUrl}}?accept={{serialization.mimeType}}")).log(LoggingLevel.INFO, LOGGER, "Serializing object ${headers[CamelFcrepoIdentifier]}")).setHeader("CamelFileName").simple("${headers[CamelFcrepoIdentifier]}.{{serialization.extension}}")).log(LoggingLevel.DEBUG, LOGGER, "filename is ${headers[CamelFileName]}")).to("file://{{serialization.descriptions}}");
        ((ExpressionNode)((ProcessorDefinition)((ExpressionNode)((ExpressionNode)((FilterDefinition)((ExpressionNode)((FilterDefinition)this.from("direct:binary").routeId("FcrepoSerializationBinaryUpdater").filter().simple("{{serialization.includeBinaries}} == 'true'")).to("fcrepo:{{fcrepo.baseUrl}}?preferInclude=PreferMinimalContainer")).filter().xpath(isBinaryResourceXPath, ns)).log(LoggingLevel.INFO, LOGGER, "Writing binary ${headers[CamelFcrepoIdentifier]}")).to("fcrepo:{{fcrepo.baseUrl}}?metadata=false")).setHeader("CamelFileName").header("CamelFcrepoIdentifier")).log(LoggingLevel.DEBUG, LOGGER, "header filename is: ${headers[CamelFileName]}")).to("file://{{serialization.binaries}}");
        ((ProcessorDefinition)this.from("direct:delete").routeId("FcrepoSerializationDeleter").setHeader("CamelExecCommandArgs").simple("-rf {{serialization.descriptions}}${headers[CamelFcrepoIdentifier]}.{{serialization.extension}} {{serialization.descriptions}}${headers[CamelFcrepoIdentifier]} {{serialization.binaries}}${headers[CamelFcrepoIdentifier]}")).to("exec:rm");
    }
}

