/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.serialization;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.fcrepo.camel.processor.EventProcessor;
import org.fcrepo.camel.processor.ProcessorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationRouter
extends RouteBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationRouter.class);
    private static final String RESOURCE_DELETION = "http://fedora.info/definitions/v4/event#ResourceDeletion";
    private static final String DELETE = "https://www.w3.org/ns/activitystreams#Delete";
    private static final String REPOSITORY = "http://fedora.info/definitions/v4/repository#";
    private static final String isBinaryResourceXPath = "/rdf:RDF/rdf:Description/rdf:type[@rdf:resource=\"http://fedora.info/definitions/v4/repository#Binary\"]";
    public static final String SERIALIZATION_PATH = "CamelSerializationPath";
    public final List<Predicate> uriFilter = ProcessorUtils.tokenizePropertyPlaceholder((CamelContext)this.getContext(), (String)"{{filter.containers}}", (String)",").stream().map(uri -> PredicateBuilder.or((Predicate)this.header("CamelFcrepoUri").startsWith((Object)this.constant(uri + "/")), (Predicate)this.header("CamelFcrepoUri").isEqualTo((Object)this.constant(uri)))).collect(Collectors.toList());

    public void configure() throws Exception {
        Namespaces ns = new Namespaces("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#").add("fedora", REPOSITORY);
        this.onException(Exception.class).maximumRedeliveries("{{error.maxRedeliveries}}").log("Index Routing Error: ${routeId}");
        ((ChoiceDefinition)((RouteDefinition)((RouteDefinition)this.from("{{input.stream}}").routeId("FcrepoSerialization").process((Processor)new EventProcessor())).process(exchange -> {
            String uri = (String)exchange.getIn().getHeader("CamelFcrepoUri", (Object)"", String.class);
            exchange.getIn().setHeader(SERIALIZATION_PATH, (Object)URI.create(uri).getPath());
        })).filter(PredicateBuilder.not((Predicate)PredicateBuilder.in(this.uriFilter))).choice().when(PredicateBuilder.or((Predicate)this.header("CamelFcrepoEventType").contains((Object)RESOURCE_DELETION), (Predicate)this.header("CamelFcrepoEventType").contains((Object)DELETE))).to("direct:delete")).otherwise().multicast().to(new String[]{"direct:metadata", "direct:binary"});
        ((ExpressionNode)this.from("{{serialization.stream}}").routeId("FcrepoReSerialization").filter(PredicateBuilder.not((Predicate)PredicateBuilder.in(this.uriFilter))).process(exchange -> {
            String uri = (String)exchange.getIn().getHeader("CamelFcrepoUri", (Object)"", String.class);
            exchange.getIn().setHeader(SERIALIZATION_PATH, (Object)URI.create(uri).getPath());
        })).multicast().to(new String[]{"direct:metadata", "direct:binary"});
        ((RouteDefinition)((ProcessorDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:metadata").routeId("FcrepoSerializationMetadataUpdater").to("fcrepo:localhost?accept={{serialization.mimeType}}")).log(LoggingLevel.INFO, LOGGER, "Serializing object ${headers[CamelFcrepoUri]}")).setHeader("CamelFileName").simple("${headers[CamelSerializationPath]}.{{serialization.extension}}")).log(LoggingLevel.DEBUG, LOGGER, "filename is ${headers[CamelFileName]}")).to("file://{{serialization.descriptions}}");
        ((ExpressionNode)((ProcessorDefinition)((ExpressionNode)((ExpressionNode)((FilterDefinition)((ExpressionNode)((FilterDefinition)this.from("direct:binary").routeId("FcrepoSerializationBinaryUpdater").filter().simple("{{serialization.includeBinaries}} == 'true'")).to("fcrepo:localhost?preferInclude=PreferMinimalContainer&accept=application/rdf+xml")).filter().xpath(isBinaryResourceXPath, ns)).log(LoggingLevel.INFO, LOGGER, "Writing binary ${headers[CamelSerializationPath]}")).to("fcrepo:localhost?metadata=false")).setHeader("CamelFileName").header(SERIALIZATION_PATH)).log(LoggingLevel.DEBUG, LOGGER, "header filename is: ${headers[CamelFileName]}")).to("file://{{serialization.binaries}}");
        ((ProcessorDefinition)this.from("direct:delete").routeId("FcrepoSerializationDeleter").setHeader("CamelExecCommandArgs").simple("-rf {{serialization.descriptions}}${headers[CamelSerializationPath]}.{{serialization.extension}} {{serialization.descriptions}}${headers[CamelSerializationPath]} {{serialization.binaries}}${headers[CamelSerializationPath]}")).to("exec:rm");
    }
}

