/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.camel.activemq;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.camel.component.activemq.ActiveMQComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.fcrepo.camel.common.config.BasePropsConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ActiveMQConfig
extends BasePropsConfig {
    @Value(value="${jms.brokerUrl:tcp://localhost:61616}")
    private String jmsBrokerUrl;
    @Value(value="${jms.username:#{null}}")
    private String jmsUsername;
    @Value(value="${jms.password:#{null}}")
    private String jmsPasword;
    @Value(value="${jms.connections:10}")
    private int jmsConnections;
    @Value(value="${jms.consumers:1}")
    private int jmsConsumers;

    @Bean
    public ActiveMQConnectionFactory connectionFactory() {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL(this.jmsBrokerUrl);
        connectionFactory.setUserName(this.jmsUsername);
        connectionFactory.setPassword(this.jmsPasword);
        return connectionFactory;
    }

    @Bean
    public ConnectionFactory pooledConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        PooledConnectionFactory pooledConnectionFactory = new PooledConnectionFactory();
        pooledConnectionFactory.setMaxConnections(this.jmsConnections);
        pooledConnectionFactory.setConnectionFactory((Object)connectionFactory);
        return pooledConnectionFactory;
    }

    @Bean
    public JmsConfiguration jmsConfiguration(PooledConnectionFactory connectionFactory) {
        JmsConfiguration configuration = new JmsConfiguration();
        configuration.setConcurrentConsumers(this.jmsConsumers);
        configuration.setConnectionFactory((ConnectionFactory)connectionFactory);
        return configuration;
    }

    @Bean(value={"broker"})
    public ActiveMQComponent activeMQComponent(JmsConfiguration jmsConfiguration) {
        ActiveMQComponent component = new ActiveMQComponent();
        component.setConfiguration(jmsConfiguration);
        return component;
    }
}

