/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoHttpClientBuilder {
    private String username;
    private String password;
    private String host;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoHttpClientBuilder.class);

    public FcrepoHttpClientBuilder(String username, String password, String host) {
        this.username = username;
        this.password = password;
        this.host = host;
    }

    public CloseableHttpClient build() {
        if (StringUtils.isBlank((CharSequence)this.username) || StringUtils.isBlank((CharSequence)this.password)) {
            return HttpClients.createDefault();
        }
        LOGGER.debug("Accessing fcrepo with user credentials");
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        AuthScope scope = null;
        scope = StringUtils.isBlank((CharSequence)this.host) ? new AuthScope(AuthScope.ANY) : new AuthScope(new HttpHost(this.host));
        credsProvider.setCredentials(scope, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
    }
}

