/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.net.URI;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpRequestBase;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.HttpMethods;
import org.fcrepo.client.RequestBuilder;

public class GetBuilder
extends RequestBuilder {
    public GetBuilder(URI uri, FcrepoClient client) {
        super(uri, client);
    }

    @Override
    protected HttpRequestBase createRequest() {
        return HttpMethods.GET.createRequest(this.targetUri);
    }

    public GetBuilder accept(String mediaType) {
        if (mediaType != null) {
            this.request.setHeader("Accept", mediaType);
        }
        return this;
    }

    public GetBuilder range(Long rangeStart, Long rangeEnd) {
        if (rangeStart != null || rangeEnd != null) {
            String range = "bytes=";
            if (rangeStart != null && rangeStart > -1L) {
                range = range + rangeStart.toString();
            }
            range = range + "-";
            if (rangeEnd != null && rangeEnd > -1L) {
                range = range + rangeEnd.toString();
            }
            this.request.setHeader("Range", range);
        }
        return this;
    }

    public GetBuilder preferMinimal() {
        this.request.setHeader("Prefer", this.buildPrefer("minimal", null, null));
        return this;
    }

    public GetBuilder preferRepresentation() {
        this.request.setHeader("Prefer", this.buildPrefer("representation", null, null));
        return this;
    }

    public GetBuilder preferRepresentation(List<URI> includeUris, List<URI> omitUris) {
        this.request.setHeader("Prefer", this.buildPrefer("representation", includeUris, omitUris));
        return this;
    }

    private String buildPrefer(String prefer, List<URI> includeUris, List<URI> omitUris) {
        String omit;
        String include;
        StringJoiner preferJoin = new StringJoiner("; ");
        preferJoin.add("return=" + prefer);
        if (includeUris != null && (include = includeUris.stream().map(URI::toString).collect(Collectors.joining(" "))).length() > 0) {
            preferJoin.add("include=\"" + include + "\"");
        }
        if (omitUris != null && (omit = omitUris.stream().map(URI::toString).collect(Collectors.joining(" "))).length() > 0) {
            preferJoin.add("omit=\"" + omit + "\"");
        }
        return preferJoin.toString();
    }

    public GetBuilder ifNoneMatch(String etag) {
        if (etag != null) {
            this.request.setHeader("If-None-Match", etag);
        }
        return this;
    }

    public GetBuilder ifModifiedSince(String lastModified) {
        if (lastModified != null) {
            this.request.setHeader("If-Modified-Since", lastModified);
        }
        return this;
    }
}

