/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.http.client.methods.HttpRequestBase;
import org.fcrepo.client.BodyRequestBuilder;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.HttpMethods;

public class PostBuilder
extends BodyRequestBuilder {
    public PostBuilder(URI uri, FcrepoClient client) {
        super(uri, client);
    }

    @Override
    protected HttpRequestBase createRequest() {
        return HttpMethods.POST.createRequest(this.targetUri);
    }

    @Override
    public PostBuilder body(InputStream stream, String contentType) {
        return (PostBuilder)super.body(stream, contentType);
    }

    @Override
    public PostBuilder body(File file, String contentType) throws IOException {
        return (PostBuilder)super.body(file, contentType);
    }

    @Override
    public PostBuilder body(InputStream stream) {
        return (PostBuilder)super.body(stream);
    }

    @Override
    @Deprecated
    public PostBuilder digest(String digest) {
        return (PostBuilder)super.digest(digest);
    }

    @Override
    public PostBuilder digest(String digest, String alg) {
        return (PostBuilder)super.digest(digest, alg);
    }

    @Override
    public PostBuilder digestMd5(String digest) {
        return (PostBuilder)super.digestMd5(digest);
    }

    @Override
    public PostBuilder digestSha1(String digest) {
        return (PostBuilder)super.digestSha1(digest);
    }

    @Override
    public PostBuilder digestSha256(String digest) {
        return (PostBuilder)super.digestSha256(digest);
    }

    public PostBuilder filename(String filename) throws FcrepoOperationFailedException {
        try {
            String f = filename != null ? "; filename=\"" + URLEncoder.encode(filename, "utf-8") + "\"" : "";
            this.request.addHeader("Content-Disposition", "attachment" + f);
        }
        catch (UnsupportedEncodingException e) {
            throw new FcrepoOperationFailedException(this.request.getURI(), -1, e.getMessage());
        }
        return this;
    }

    public PostBuilder slug(String slug) {
        if (slug != null) {
            this.request.addHeader("Slug", slug);
        }
        return this;
    }
}

