/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.http.client.methods.HttpRequestBase;
import org.fcrepo.client.BodyRequestBuilder;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.HttpMethods;

public class PutBuilder
extends BodyRequestBuilder {
    public PutBuilder(URI uri, FcrepoClient client) {
        super(uri, client);
    }

    @Override
    protected HttpRequestBase createRequest() {
        return HttpMethods.PUT.createRequest(this.targetUri);
    }

    @Override
    public PutBuilder body(InputStream stream, String contentType) {
        return (PutBuilder)super.body(stream, contentType);
    }

    @Override
    public PutBuilder body(File file, String contentType) throws IOException {
        return (PutBuilder)super.body(file, contentType);
    }

    @Override
    public PutBuilder body(InputStream stream) {
        return (PutBuilder)super.body(stream);
    }

    @Override
    public PutBuilder ifMatch(String etag) {
        return (PutBuilder)super.ifMatch(etag);
    }

    @Override
    public PutBuilder ifUnmodifiedSince(String modified) {
        return (PutBuilder)super.ifUnmodifiedSince(modified);
    }

    @Override
    @Deprecated
    public PutBuilder digest(String digest) {
        return (PutBuilder)super.digest(digest);
    }

    @Override
    public PutBuilder digest(String digest, String alg) {
        return (PutBuilder)super.digest(digest, alg);
    }

    @Override
    public PutBuilder digestMd5(String digest) {
        return (PutBuilder)super.digestMd5(digest);
    }

    @Override
    public PutBuilder digestSha1(String digest) {
        return (PutBuilder)super.digestSha1(digest);
    }

    @Override
    public PutBuilder digestSha256(String digest) {
        return (PutBuilder)super.digestSha256(digest);
    }

    public PutBuilder filename(String filename) throws FcrepoOperationFailedException {
        try {
            String f = filename != null ? "; filename=\"" + URLEncoder.encode(filename, "utf-8") + "\"" : "";
            this.request.addHeader("Content-Disposition", "attachment" + f);
        }
        catch (UnsupportedEncodingException e) {
            throw new FcrepoOperationFailedException(this.request.getURI(), -1, e.getMessage());
        }
        return this;
    }

    public BodyRequestBuilder preferLenient() {
        this.request.setHeader("Prefer", "handling=lenient; received=\"minimal\"");
        return this;
    }
}

