/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.net.URI;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.Args;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.FcrepoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RequestBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestBuilder.class);
    protected FcrepoClient client;
    protected URI targetUri;
    protected HttpRequestBase request;

    protected RequestBuilder(URI uri, FcrepoClient client) {
        Args.notNull((Object)uri, (String)"uri");
        Args.notNull((Object)client, (String)"client");
        this.targetUri = uri;
        this.client = client;
        this.request = this.createRequest();
    }

    protected abstract HttpRequestBase createRequest();

    public FcrepoResponse perform() throws FcrepoOperationFailedException {
        LOGGER.debug("Fcrepo {} request to {} with headers: {}", new Object[]{this.request.getMethod(), this.targetUri, this.request.getAllHeaders()});
        return this.client.executeRequest(this.targetUri, this.request);
    }
}

