/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpRequestBase;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoLink;
import org.fcrepo.client.HttpMethods;
import org.fcrepo.client.RetrieveRequestBuilder;

public class GetBuilder
extends RetrieveRequestBuilder {
    public GetBuilder(URI uri, FcrepoClient client) {
        super(uri, client);
    }

    @Override
    protected HttpRequestBase createRequest() {
        return HttpMethods.GET.createRequest(this.targetUri);
    }

    public GetBuilder accept(String mediaType) {
        if (mediaType != null) {
            this.request.setHeader("Accept", mediaType);
        }
        return this;
    }

    public GetBuilder range(Long rangeStart, Long rangeEnd) {
        if (rangeStart != null || rangeEnd != null) {
            String range = "bytes=";
            if (rangeStart != null && rangeStart > -1L) {
                range = range + rangeStart.toString();
            }
            range = range + "-";
            if (rangeEnd != null && rangeEnd > -1L) {
                range = range + rangeEnd.toString();
            }
            this.request.setHeader("Range", range);
        }
        return this;
    }

    public GetBuilder preferMinimal() {
        this.request.setHeader("Prefer", "return=minimal");
        return this;
    }

    public GetBuilder preferRepresentation() {
        this.request.setHeader("Prefer", "return=representation");
        return this;
    }

    public GetBuilder preferRepresentation(List<URI> includeUris, List<URI> omitUris) {
        this.request.setHeader("Prefer", this.buildPrefer(includeUris, omitUris));
        return this;
    }

    private String buildPrefer(List<URI> includeUris, List<URI> omitUris) {
        String omit;
        String include;
        StringJoiner preferJoin = new StringJoiner("; ");
        preferJoin.add("return=representation");
        if (includeUris != null && (include = includeUris.stream().map(URI::toString).collect(Collectors.joining(" "))).length() > 0) {
            preferJoin.add("include=\"" + include + "\"");
        }
        if (omitUris != null && (omit = omitUris.stream().map(URI::toString).collect(Collectors.joining(" "))).length() > 0) {
            preferJoin.add("omit=\"" + omit + "\"");
        }
        return preferJoin.toString();
    }

    public GetBuilder ifNoneMatch(String etag) {
        if (etag != null) {
            this.request.setHeader("If-None-Match", etag);
        }
        return this;
    }

    public GetBuilder ifModifiedSince(String lastModified) {
        if (lastModified != null) {
            this.request.setHeader("If-Modified-Since", lastModified);
        }
        return this;
    }

    @Override
    public GetBuilder disableRedirects() {
        return (GetBuilder)super.disableRedirects();
    }

    @Override
    public GetBuilder wantDigest(String value) {
        return (GetBuilder)super.wantDigest(value);
    }

    @Override
    public GetBuilder noCache() {
        return (GetBuilder)super.noCache();
    }

    @Override
    public GetBuilder acceptDatetime(Instant acceptInstant) {
        return (GetBuilder)super.acceptDatetime(acceptInstant);
    }

    @Override
    public GetBuilder acceptDatetime(String acceptDatetime) {
        return (GetBuilder)super.acceptDatetime(acceptDatetime);
    }

    @Override
    public GetBuilder addHeader(String name, String value) {
        return (GetBuilder)super.addHeader(name, value);
    }

    @Override
    public GetBuilder addLinkHeader(FcrepoLink linkHeader) {
        return (GetBuilder)super.addLinkHeader(linkHeader);
    }
}

