/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoLink;
import org.fcrepo.client.RequestBuilder;

public abstract class BodyRequestBuilder
extends RequestBuilder {
    private StringJoiner digestJoiner;

    protected BodyRequestBuilder(URI uri, FcrepoClient client) {
        super(uri, client);
    }

    protected BodyRequestBuilder body(InputStream stream) {
        return this.body(stream, null);
    }

    protected BodyRequestBuilder body(InputStream stream, String contentType) {
        if (stream != null) {
            String type = contentType;
            if (type == null) {
                type = "application/octet-stream";
            }
            ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)new InputStreamEntity(stream));
            this.request.addHeader("Content-Type", type);
        }
        return this;
    }

    protected BodyRequestBuilder body(File file, String contentType) throws IOException {
        return this.body(new FileInputStream(file), contentType);
    }

    protected BodyRequestBuilder externalContent(URI contentURI, String contentType, String handling) {
        FcrepoLink.Builder linkBuilder = FcrepoLink.fromUri(contentURI).rel("http://fedora.info/definitions/fcrepo#ExternalContent").param("handling", handling);
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            linkBuilder.type(contentType);
        }
        this.request.addHeader("Link", linkBuilder.build().toString());
        return this;
    }

    @Deprecated
    protected BodyRequestBuilder digest(String digest) {
        return this.digestSha1(digest);
    }

    protected BodyRequestBuilder digest(String digest, String alg) {
        if (digest != null) {
            if (this.digestJoiner == null) {
                this.digestJoiner = new StringJoiner(", ");
            }
            this.digestJoiner.add(alg + "=" + digest);
            this.request.setHeader("digest", this.digestJoiner.toString());
        }
        return this;
    }

    protected BodyRequestBuilder digestSha1(String digest) {
        return this.digest(digest, "sha");
    }

    protected BodyRequestBuilder digestMd5(String digest) {
        return this.digest(digest, "md5");
    }

    protected BodyRequestBuilder digestSha256(String digest) {
        return this.digest(digest, "sha256");
    }

    protected BodyRequestBuilder addInteractionModel(String interactionModelUri) {
        if (interactionModelUri != null) {
            FcrepoLink link = FcrepoLink.fromUri(interactionModelUri).rel("type").build();
            this.request.addHeader("Link", link.toString());
        }
        return this;
    }

    public BodyRequestBuilder ifUnmodifiedSince(String modified) {
        if (modified != null) {
            this.request.setHeader("If-Unmodified-Since", modified);
        }
        return this;
    }

    protected BodyRequestBuilder ifMatch(String etag) {
        if (etag != null) {
            this.request.setHeader("If-Match", etag);
        }
        return this;
    }

    protected BodyRequestBuilder linkAcl(String aclUri) {
        if (aclUri != null) {
            FcrepoLink link = FcrepoLink.fromUri(aclUri).rel("acl").build();
            this.request.addHeader("Link", link.toString());
        }
        return this;
    }

    protected BodyRequestBuilder ifStateToken(String token) {
        if (token != null) {
            this.request.setHeader("X-If-State-Token", token);
        }
        return this;
    }
}

