/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FcrepoLink {
    private static final String PARAM_DELIM = ";";
    private static final String META_REL = "rel";
    private static final String META_TYPE = "type";
    private URI uri;
    private Map<String, String> params;

    public FcrepoLink(String link) {
        if (link == null) {
            throw new IllegalArgumentException("Link header did not contain a URI");
        }
        this.params = new HashMap<String, String>();
        this.parse(link);
    }

    private FcrepoLink(URI uri, Map<String, String> params) {
        this.uri = uri;
        this.params = params;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getRel() {
        return this.getParam(META_REL);
    }

    public String getType() {
        return this.getParam(META_TYPE);
    }

    public String getParam(String name) {
        return this.params.get(name);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    private void parse(String link) {
        int paramIndex = link.indexOf(PARAM_DELIM);
        if (paramIndex == -1) {
            this.uri = FcrepoLink.getLinkPart(link);
        } else {
            this.uri = FcrepoLink.getLinkPart(link.substring(0, paramIndex));
            this.parseParams(link.substring(paramIndex + 1));
        }
    }

    private void parseParams(String paramString) {
        StringTokenizer st = new StringTokenizer(paramString, ";\",", true);
        while (st.hasMoreTokens()) {
            boolean inQuotes = false;
            StringBuilder paramBuilder = new StringBuilder();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals("\"")) {
                    inQuotes = !inQuotes;
                    continue;
                }
                if (!inQuotes && token.equals(PARAM_DELIM)) break;
                if (!inQuotes && token.equals(",")) {
                    throw new IllegalArgumentException("Cannot parse link, contains unterminated quotes");
                }
                paramBuilder.append(token);
            }
            if (inQuotes) {
                throw new IllegalArgumentException("Cannot parse link, contains unterminated quotes");
            }
            String param = paramBuilder.toString();
            String[] components = param.split("=", 2);
            if (components.length == 2) {
                String name = components[0].trim();
                String value = components[1].trim();
                this.params.put(name, value);
                continue;
            }
            throw new IllegalArgumentException("Cannot parse link, improperly structured parameter encountered: " + param);
        }
    }

    private static String stripQuotes(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('<').append(this.uri.toString()).append('>');
        this.params.forEach((name, value) -> result.append("; ").append((String)name).append("=\"").append((String)value).append('\"'));
        return result.toString();
    }

    private static URI getLinkPart(String uriPart) {
        String linkPart = uriPart.trim();
        if (!linkPart.startsWith("<") || !linkPart.endsWith(">")) {
            throw new IllegalArgumentException("Link header did not contain a URI");
        }
        return URI.create(linkPart.substring(1, linkPart.length() - 1));
    }

    public static Builder fromUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI is required");
        }
        return new Builder().uri(uri);
    }

    public static Builder fromUri(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI is required");
        }
        return new Builder().uri(uri);
    }

    public static FcrepoLink valueOf(String link) {
        return new FcrepoLink(link);
    }

    public static List<FcrepoLink> fromHeader(String headerValue) {
        ArrayList<FcrepoLink> links = new ArrayList<FcrepoLink>();
        boolean inQuotes = false;
        boolean inUri = false;
        StringBuilder currentLink = new StringBuilder();
        StringTokenizer st = new StringTokenizer(headerValue, ",\"<>", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(",")) {
                if (!inQuotes && !inUri) {
                    links.add(new FcrepoLink(currentLink.toString().trim()));
                    currentLink = new StringBuilder();
                    continue;
                }
            } else if (token.equals("\"") && !inUri) {
                inQuotes = !inQuotes;
            } else if (token.equals("<") && !inQuotes) {
                inUri = true;
            } else if (token.equals(">") && !inQuotes) {
                inUri = false;
            }
            currentLink.append(token);
        }
        if (inQuotes) {
            throw new IllegalArgumentException("Cannot parse link header, contains unterminated quotes: " + headerValue);
        }
        if (inUri) {
            throw new IllegalArgumentException("Cannot parse link header, contains unterminated URI: " + headerValue);
        }
        links.add(new FcrepoLink(currentLink.toString().trim()));
        return links;
    }

    public static class Builder {
        private URI uri;
        private Map<String, String> params = new HashMap<String, String>();

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = URI.create(uri);
            return this;
        }

        public Builder rel(String rel) {
            return this.param(FcrepoLink.META_REL, rel);
        }

        public Builder type(String type) {
            return this.param(FcrepoLink.META_TYPE, type);
        }

        public Builder param(String name, String value) {
            this.params.put(name, FcrepoLink.stripQuotes(value));
            return this;
        }

        public FcrepoLink build() {
            return new FcrepoLink(this.uri, this.params);
        }
    }
}

