/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class HeaderHelpers {
    public static DateTimeFormatter UTC_RFC_1123_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.of("UTC"));

    public static String formatQualityValues(Map<String, ? extends Object> qualityMap) {
        Map<Optional, List<Map.Entry>> qualityToVal = qualityMap.entrySet().stream().collect(Collectors.groupingBy(e -> Optional.ofNullable(e.getValue())));
        return qualityToVal.entrySet().stream().map(e -> {
            String joinedValues = ((List)e.getValue()).stream().map(Map.Entry::getKey).collect(Collectors.joining(","));
            if (((Optional)e.getKey()).isPresent()) {
                return joinedValues + ";q=" + ((Optional)e.getKey()).get();
            }
            return joinedValues;
        }).collect(Collectors.joining(", "));
    }

    private HeaderHelpers() {
    }
}

