/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.net.URI;
import java.time.Instant;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.HeaderHelpers;
import org.fcrepo.client.PostBuilder;

public class HistoricMementoBuilder
extends PostBuilder {
    public HistoricMementoBuilder(URI uri, FcrepoClient client, Instant mementoInstant) {
        super(uri, client);
        String rfc1123Datetime = HeaderHelpers.UTC_RFC_1123_FORMATTER.format(mementoInstant);
        this.request.setHeader("Memento-Datetime", rfc1123Datetime);
    }

    public HistoricMementoBuilder(URI uri, FcrepoClient client, String mementoDatetime) {
        super(uri, client);
        HeaderHelpers.UTC_RFC_1123_FORMATTER.parse(mementoDatetime);
        this.request.setHeader("Memento-Datetime", mementoDatetime);
    }
}

