/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.net.URI;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

public enum HttpMethods {
    GET(HttpGet.class),
    PATCH(HttpPatch.class),
    POST(HttpPost.class),
    PUT(HttpPut.class),
    DELETE(HttpDelete.class),
    HEAD(HttpHead.class),
    OPTIONS(HttpOptions.class),
    MOVE(HttpMove.class),
    COPY(HttpCopy.class);

    final Class<? extends HttpRequestBase> clazz;
    final boolean entity;

    private HttpMethods(Class<? extends HttpRequestBase> clazz) {
        this.clazz = clazz;
        this.entity = HttpEntityEnclosingRequestBase.class.isAssignableFrom(clazz);
    }

    public HttpRequestBase createRequest(URI url) {
        try {
            return this.clazz.getDeclaredConstructor(URI.class).newInstance(url);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class HttpCopy
    extends HttpRequestBase {
        public static final String METHOD_NAME = "COPY";

        public HttpCopy(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }

    public static class HttpMove
    extends HttpRequestBase {
        public static final String METHOD_NAME = "MOVE";

        public HttpMove(URI uri) {
            this.setURI(uri);
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

