/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.net.URI;
import java.time.Instant;
import org.apache.http.client.config.RequestConfig;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.HeaderHelpers;
import org.fcrepo.client.RequestBuilder;

public abstract class RetrieveRequestBuilder
extends RequestBuilder {
    protected RetrieveRequestBuilder(URI uri, FcrepoClient client) {
        super(uri, client);
    }

    public RetrieveRequestBuilder disableRedirects() {
        this.request.setConfig(RequestConfig.custom().setRedirectsEnabled(false).build());
        return this;
    }

    public RetrieveRequestBuilder wantDigest(String value) {
        if (value != null) {
            this.request.setHeader("Want-Digest", value);
        }
        return this;
    }

    public RetrieveRequestBuilder noCache() {
        this.request.setHeader("Cache-Control", "no-cache");
        return this;
    }

    public RetrieveRequestBuilder acceptDatetime(Instant acceptInstant) {
        if (acceptInstant != null) {
            String rfc1123Datetime = HeaderHelpers.UTC_RFC_1123_FORMATTER.format(acceptInstant);
            this.request.setHeader("Accept-Datetime", rfc1123Datetime);
        }
        return this;
    }

    public RetrieveRequestBuilder acceptDatetime(String acceptDatetime) {
        if (acceptDatetime != null) {
            HeaderHelpers.UTC_RFC_1123_FORMATTER.parse(acceptDatetime);
            this.request.setHeader("Accept-Datetime", acceptDatetime);
        }
        return this;
    }
}

