/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Instant;
import org.apache.http.client.methods.HttpRequestBase;
import org.fcrepo.client.BodyRequestBuilder;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoLink;
import org.fcrepo.client.FcrepoOperationFailedException;
import org.fcrepo.client.HeaderHelpers;
import org.fcrepo.client.HttpMethods;
import org.springframework.http.ContentDisposition;

public class HistoricMementoBuilder
extends BodyRequestBuilder {
    public HistoricMementoBuilder(URI uri, FcrepoClient client, Instant mementoInstant) {
        super(uri, client);
        String rfc1123Datetime = HeaderHelpers.UTC_RFC_1123_FORMATTER.format(mementoInstant);
        this.request.setHeader("Memento-Datetime", rfc1123Datetime);
    }

    public HistoricMementoBuilder(URI uri, FcrepoClient client, String mementoDatetime) {
        super(uri, client);
        HeaderHelpers.UTC_RFC_1123_FORMATTER.parse(mementoDatetime);
        this.request.setHeader("Memento-Datetime", mementoDatetime);
    }

    @Override
    protected HttpRequestBase createRequest() {
        return HttpMethods.POST.createRequest(this.targetUri);
    }

    @Override
    public HistoricMementoBuilder body(InputStream stream, String contentType) {
        return (HistoricMementoBuilder)super.body(stream, contentType);
    }

    @Override
    public HistoricMementoBuilder body(File file, String contentType) throws IOException {
        return (HistoricMementoBuilder)super.body(file, contentType);
    }

    @Override
    public HistoricMementoBuilder body(InputStream stream) {
        return (HistoricMementoBuilder)super.body(stream);
    }

    @Override
    public HistoricMementoBuilder externalContent(URI contentURI, String contentType, String handling) {
        return (HistoricMementoBuilder)super.externalContent(contentURI, contentType, handling);
    }

    @Override
    public HistoricMementoBuilder digest(String digest, String alg) {
        return (HistoricMementoBuilder)super.digest(digest, alg);
    }

    @Override
    public HistoricMementoBuilder digestMd5(String digest) {
        return (HistoricMementoBuilder)super.digestMd5(digest);
    }

    @Override
    public HistoricMementoBuilder digestSha1(String digest) {
        return (HistoricMementoBuilder)super.digestSha1(digest);
    }

    @Override
    public HistoricMementoBuilder digestSha256(String digest) {
        return (HistoricMementoBuilder)super.digestSha256(digest);
    }

    @Override
    public HistoricMementoBuilder addInteractionModel(String interactionModelUri) {
        return (HistoricMementoBuilder)super.addInteractionModel(interactionModelUri);
    }

    @Override
    public HistoricMementoBuilder linkAcl(String aclUri) {
        return (HistoricMementoBuilder)super.linkAcl(aclUri);
    }

    @Override
    public HistoricMementoBuilder addHeader(String name, String value) {
        return (HistoricMementoBuilder)super.addHeader(name, value);
    }

    @Override
    public HistoricMementoBuilder addLinkHeader(FcrepoLink linkHeader) {
        return (HistoricMementoBuilder)super.addLinkHeader(linkHeader);
    }

    public HistoricMementoBuilder filename(String filename) throws FcrepoOperationFailedException {
        ContentDisposition.Builder builder = ContentDisposition.builder((String)"attachment");
        if (filename != null) {
            builder.filename(filename);
        }
        this.request.addHeader("Content-Disposition", builder.build().toString());
        return this;
    }

    public HistoricMementoBuilder slug(String slug) {
        if (slug != null) {
            this.request.addHeader("Slug", slug);
        }
        return this;
    }
}

