/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.net.URI;
import org.fcrepo.client.DeleteBuilder;
import org.fcrepo.client.FcrepoClient;
import org.fcrepo.client.FcrepoHttpClientBuilder;
import org.fcrepo.client.GetBuilder;
import org.fcrepo.client.HeadBuilder;
import org.fcrepo.client.OptionsBuilder;
import org.fcrepo.client.PatchBuilder;
import org.fcrepo.client.PostBuilder;
import org.fcrepo.client.PutBuilder;

public class TransactionalFcrepoClient
extends FcrepoClient {
    private final URI transactionURI;

    public TransactionalFcrepoClient(URI transactionURI, FcrepoHttpClientBuilder httpClientBuilder, Boolean throwExceptionOnFailure) {
        super(httpClientBuilder, throwExceptionOnFailure);
        if (transactionURI == null) {
            throw new IllegalArgumentException("TransactionURI cannot be null");
        }
        this.transactionURI = transactionURI;
    }

    public URI getTransactionURI() {
        return this.transactionURI;
    }

    public PutBuilder commit() {
        return this.put(this.transactionURI);
    }

    public GetBuilder status() {
        return this.get(this.transactionURI);
    }

    public PostBuilder keepAlive() {
        return this.post(this.transactionURI);
    }

    public DeleteBuilder rollback() {
        return this.delete(this.transactionURI);
    }

    @Override
    public GetBuilder get(URI url) {
        GetBuilder builder = super.get(url);
        builder.addTransaction(this.transactionURI);
        return builder;
    }

    @Override
    public HeadBuilder head(URI url) {
        HeadBuilder builder = super.head(url);
        builder.addTransaction(this.transactionURI);
        return builder;
    }

    @Override
    public DeleteBuilder delete(URI url) {
        DeleteBuilder builder = super.delete(url);
        builder.addTransaction(this.transactionURI);
        return builder;
    }

    @Override
    public OptionsBuilder options(URI url) {
        OptionsBuilder builder = super.options(url);
        builder.addTransaction(this.transactionURI);
        return builder;
    }

    @Override
    public PatchBuilder patch(URI url) {
        PatchBuilder builder = super.patch(url);
        builder.addTransaction(this.transactionURI);
        return builder;
    }

    @Override
    public PostBuilder post(URI url) {
        PostBuilder builder = super.post(url);
        builder.addTransaction(this.transactionURI);
        return builder;
    }

    @Override
    public PutBuilder put(URI url) {
        PutBuilder builder = super.put(url);
        builder.addTransaction(this.transactionURI);
        return builder;
    }
}

