/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth;

import java.security.Principal;
import java.util.Set;
import org.fcrepo.auth.FedoraPolicyEnforcementPoint;
import org.fcrepo.auth.ServletContainerAuthenticationProvider;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.jcr.security.AdvancedAuthorizationProvider;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.value.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraUserSecurityContext
implements SecurityContext,
AdvancedAuthorizationProvider {
    private static Logger log = LoggerFactory.getLogger(FedoraUserSecurityContext.class);
    private Set<Principal> principals = null;
    private Principal userPrincipal = null;
    private ServletCredentials credentials = null;
    private FedoraPolicyEnforcementPoint pep = null;
    private boolean loggedIn = true;

    protected FedoraUserSecurityContext(ServletCredentials credentials, Set<Principal> principals, FedoraPolicyEnforcementPoint pep) {
        this.credentials = credentials;
        this.principals = principals;
        this.pep = pep;
        if (credentials.getRequest() != null) {
            this.userPrincipal = credentials.getRequest().getUserPrincipal();
        }
        if (this.pep == null) {
            log.warn("This security context must have a PEP injected");
            throw new Error("This security context must have a PEP injected");
        }
    }

    public boolean isAnonymous() {
        return this.userPrincipal == null;
    }

    public final String getUserName() {
        return this.getEffectiveUserPrincipal().getName();
    }

    public final boolean hasRole(String roleName) {
        if ("read".equals(roleName)) {
            return true;
        }
        if ("write".equals(roleName)) {
            return true;
        }
        return "admin".equals(roleName);
    }

    public Principal getEffectiveUserPrincipal() {
        if (this.loggedIn && this.userPrincipal != null) {
            return this.userPrincipal;
        }
        return ServletContainerAuthenticationProvider.EVERYONE;
    }

    public void logout() {
        this.loggedIn = false;
    }

    public boolean hasPermission(AdvancedAuthorizationProvider.Context context, Path absPath, String ... actions) {
        if (!this.loggedIn) {
            return false;
        }
        if (absPath == null) {
            return actions.length == 1 && "read".equals(actions[0]);
        }
        if (this.pep != null) {
            return this.pep.hasModeShapePermission(absPath, actions, this.principals, this.getEffectiveUserPrincipal());
        }
        return false;
    }
}

