/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.auth.FedoraAdminSecurityContext;
import org.fcrepo.auth.FedoraPolicyEnforcementPoint;
import org.fcrepo.auth.FedoraUserSecurityContext;
import org.fcrepo.auth.HTTPPrincipalFactory;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.jcr.security.AuthenticationProvider;
import org.modeshape.jcr.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerAuthenticationProvider
implements AuthenticationProvider {
    private static ServletContainerAuthenticationProvider _instance = null;
    public static final String EVERYONE_NAME = "EVERYONE";
    public static final Principal EVERYONE = new Principal(){

        @Override
        public String getName() {
            return ServletContainerAuthenticationProvider.EVERYONE_NAME;
        }
    };
    public static final String FEDORA_ADMIN_ROLE = "fedoraAdmin";
    public static final String FEDORA_USER_ROLE = "fedoraUser";
    private static final Logger logger = LoggerFactory.getLogger(ServletContainerAuthenticationProvider.class);
    private Set<HTTPPrincipalFactory> principalFactories = Collections.emptySet();
    private FedoraPolicyEnforcementPoint pep;

    private ServletContainerAuthenticationProvider() {
        _instance = this;
    }

    public static synchronized AuthenticationProvider getInstance() {
        if (_instance != null) {
            return _instance;
        }
        _instance = new ServletContainerAuthenticationProvider();
        logger.warn("Security is MINIMAL, no Policy Enforcement Point configured.");
        return _instance;
    }

    public Set<HTTPPrincipalFactory> getPrincipalFactories() {
        return this.principalFactories;
    }

    public void setPrincipalFactories(Set<HTTPPrincipalFactory> principalFactories) {
        this.principalFactories = principalFactories;
    }

    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        logger.debug("in authenticate: " + credentials);
        logger.debug("PEP: " + this.pep);
        if (credentials == null || !(credentials instanceof ServletCredentials)) {
            return null;
        }
        ServletCredentials creds = (ServletCredentials)credentials;
        if (creds.getRequest().getUserPrincipal() != null && creds.getRequest().isUserInRole(FEDORA_ADMIN_ROLE)) {
            return repositoryContext.with((SecurityContext)new FedoraAdminSecurityContext(creds.getRequest().getUserPrincipal().getName()));
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(EVERYONE);
        if (creds.getRequest().getUserPrincipal() != null && creds.getRequest().isUserInRole(FEDORA_USER_ROLE)) {
            principals.add(creds.getRequest().getUserPrincipal());
            this.addUserPrincipals(creds.getRequest(), principals);
        }
        return repositoryContext.with((SecurityContext)new FedoraUserSecurityContext(creds, principals, this.pep));
    }

    public FedoraPolicyEnforcementPoint getPep() {
        return this.pep;
    }

    public void setPep(FedoraPolicyEnforcementPoint pep) {
        this.pep = pep;
    }

    private void addUserPrincipals(HttpServletRequest request, Set<Principal> principals) {
        for (HTTPPrincipalFactory pf : this.getPrincipalFactories()) {
            principals.addAll(pf.getGroupPrincipals(request));
        }
    }
}

