/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.security.Principal;
import org.fcrepo.auth.common.FedoraAuthorizationDelegate;
import org.fcrepo.auth.common.ServletContainerAuthenticationProvider;
import org.modeshape.jcr.security.AdvancedAuthorizationProvider;
import org.modeshape.jcr.security.SecurityContext;
import org.modeshape.jcr.value.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraUserSecurityContext
implements SecurityContext,
AdvancedAuthorizationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FedoraUserSecurityContext.class);
    private Principal userPrincipal = null;
    private FedoraAuthorizationDelegate fad = null;
    private boolean loggedIn = true;

    protected FedoraUserSecurityContext(Principal userPrincipal, FedoraAuthorizationDelegate fad) {
        this.fad = fad;
        this.userPrincipal = userPrincipal;
        if (this.fad == null) {
            LOGGER.warn("This security context must have a FAD injected");
            throw new IllegalArgumentException("This security context must have a FAD injected");
        }
    }

    public boolean isAnonymous() {
        return this.userPrincipal == null;
    }

    public final String getUserName() {
        return this.getEffectiveUserPrincipal().getName();
    }

    public final boolean hasRole(String roleName) {
        if ("read".equals(roleName)) {
            return true;
        }
        if ("write".equals(roleName)) {
            return true;
        }
        return "admin".equals(roleName);
    }

    public Principal getEffectiveUserPrincipal() {
        if (this.loggedIn && this.userPrincipal != null) {
            return this.userPrincipal;
        }
        return ServletContainerAuthenticationProvider.EVERYONE;
    }

    public void logout() {
        this.loggedIn = false;
    }

    public boolean hasPermission(AdvancedAuthorizationProvider.Context context, Path absPath, String ... actions) {
        if (!this.loggedIn) {
            return false;
        }
        if (absPath == null) {
            return actions.length == 1 && "read".equals(actions[0]);
        }
        if (this.fad != null) {
            return this.fad.hasPermission(context.getSession(), absPath, actions);
        }
        return false;
    }
}

