/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.auth.common.PrincipalProvider;
import org.modeshape.jcr.api.ServletCredentials;

public class HttpHeaderPrincipalProvider
implements PrincipalProvider {
    private String headerName;
    private String separator = "";

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    public Set<Principal> getPrincipals(Credentials credentials) {
        if (this.headerName == null || this.separator == null) {
            return Collections.emptySet();
        }
        if (!(credentials instanceof ServletCredentials)) {
            return Collections.emptySet();
        }
        ServletCredentials servletCredentials = (ServletCredentials)credentials;
        HttpServletRequest request = servletCredentials.getRequest();
        if (request == null) {
            return Collections.emptySet();
        }
        String value = request.getHeader(this.headerName);
        if (value == null) {
            return Collections.emptySet();
        }
        String[] names = value.split(this.separator);
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String name : names) {
            principals.add(new HttpHeaderPrincipal(name.trim()));
        }
        return principals;
    }

    protected static class HttpHeaderPrincipal
    implements Principal {
        private final String name;

        HttpHeaderPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof HttpHeaderPrincipal) {
                return ((HttpHeaderPrincipal)o).getName().equals(this.getName());
            }
            return false;
        }

        @Override
        public int hashCode() {
            if (this.name == null) {
                return 0;
            }
            return this.name.hashCode();
        }
    }
}

