/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.servlet.http.HttpServletRequest;
import org.fcrepo.auth.common.FedoraAdminSecurityContext;
import org.fcrepo.auth.common.FedoraAuthorizationDelegate;
import org.fcrepo.auth.common.FedoraUserSecurityContext;
import org.fcrepo.auth.common.PrincipalProvider;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.jcr.security.AuthenticationProvider;
import org.modeshape.jcr.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServletContainerAuthenticationProvider
implements AuthenticationProvider {
    private static ServletContainerAuthenticationProvider instance = null;
    public static final String EVERYONE_NAME = "EVERYONE";
    public static final Principal EVERYONE = new Principal(){

        @Override
        public String getName() {
            return ServletContainerAuthenticationProvider.EVERYONE_NAME;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    };
    public static final String FEDORA_ADMIN_ROLE = "fedoraAdmin";
    public static final String FEDORA_USER_ROLE = "fedoraUser";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletContainerAuthenticationProvider.class);
    private Set<PrincipalProvider> principalProviders = Collections.emptySet();
    private FedoraAuthorizationDelegate fad;

    private ServletContainerAuthenticationProvider() {
        instance = this;
    }

    public static synchronized AuthenticationProvider getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ServletContainerAuthenticationProvider();
        LOGGER.warn("Security is MINIMAL, no Policy Enforcement Point configured.");
        return instance;
    }

    public Set<PrincipalProvider> getPrincipalProviders() {
        return this.principalProviders;
    }

    public void setPrincipalProviders(Set<PrincipalProvider> principalProviders) {
        this.principalProviders = principalProviders;
    }

    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        LOGGER.debug("Trying to authenticate: {}; FAD: {}", (Object)credentials, (Object)this.fad);
        if (!(credentials instanceof ServletCredentials)) {
            return null;
        }
        HttpServletRequest servletRequest = ((ServletCredentials)credentials).getRequest();
        Principal userPrincipal = servletRequest.getUserPrincipal();
        if (userPrincipal != null && servletRequest.isUserInRole(FEDORA_ADMIN_ROLE)) {
            return repositoryContext.with((SecurityContext)new FedoraAdminSecurityContext(userPrincipal.getName()));
        }
        if (userPrincipal != null) {
            sessionAttributes.put("fedora-servlet-request", servletRequest);
            sessionAttributes.put("fedora-user-principal", userPrincipal);
            Set<Principal> principals = this.collectPrincipals(credentials);
            principals.add(userPrincipal);
            principals.add(EVERYONE);
            sessionAttributes.put("fedora-all-principals", principals);
        } else {
            sessionAttributes.put("fedora-user-principal", EVERYONE);
            sessionAttributes.put("fedora-all-principals", Collections.singleton(EVERYONE));
        }
        return repositoryContext.with((SecurityContext)new FedoraUserSecurityContext(userPrincipal, this.fad));
    }

    public FedoraAuthorizationDelegate getFad() {
        return this.fad;
    }

    public void setFad(FedoraAuthorizationDelegate fad) {
        this.fad = fad;
    }

    private Set<Principal> collectPrincipals(Credentials credentials) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (PrincipalProvider p : this.getPrincipalProviders()) {
            Set<Principal> ps = p.getPrincipals(credentials);
            if (ps == null) continue;
            principals.addAll(p.getPrincipals(credentials));
        }
        return principals;
    }
}

