/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.auth.common;

import java.security.Principal;
import java.util.Set;
import javax.jcr.Credentials;
import org.fcrepo.auth.common.HttpHeaderPrincipalProvider;
import org.fcrepo.kernel.api.exception.RepositoryConfigurationException;

public class DelegateHeaderPrincipalProvider
extends HttpHeaderPrincipalProvider {
    private static final String SEP = "no-separator";
    protected static final String DELEGATE_HEADER = "On-Behalf-Of";

    public DelegateHeaderPrincipalProvider() {
        this.setHeaderName(DELEGATE_HEADER);
        this.setSeparator(SEP);
    }

    public Principal getDelegate(Credentials credentials) {
        Set<Principal> principals = this.getPrincipals(credentials);
        if (principals.size() == 0) {
            return null;
        }
        if (principals.size() == 1) {
            return principals.iterator().next();
        }
        throw new RepositoryConfigurationException("Too many delegates! " + principals);
    }
}

